/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private ArrayList<Query> disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query) {
        this.disjuncts.add(query);
    }

    public void add(Collection<Query> disjuncts) {
        this.disjuncts.addAll(disjuncts);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.disjuncts.iterator();
    }

    public ArrayList<Query> getDisjuncts() {
        return this.disjuncts;
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            Query singleton = this.disjuncts.get(0);
            Query result2 = singleton.rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (result2 == singleton) {
                    result2 = result2.clone();
                }
                result2.setBoost(this.getBoost() * result2.getBoost());
            }
            return result2;
        }
        DisjunctionMaxQuery clone2 = null;
        for (int i = 0; i < numDisjunctions; ++i) {
            Query clause = this.disjuncts.get(i);
            Query rewrite = clause.rewrite(reader);
            if (rewrite == clause) continue;
            if (clone2 == null) {
                clone2 = this.clone();
            }
            clone2.disjuncts.set(i, rewrite);
        }
        if (clone2 != null) {
            return clone2;
        }
        return this;
    }

    @Override
    public DisjunctionMaxQuery clone() {
        DisjunctionMaxQuery clone2 = (DisjunctionMaxQuery)super.clone();
        clone2.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone2;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        for (Query query : this.disjuncts) {
            query.extractTerms(terms);
        }
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i = 0; i < numDisjunctions; ++i) {
            Query subquery = this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field2));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field2));
            }
            if (i == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return this.getBoost() == other.getBoost() && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected ArrayList<Weight> weights = new ArrayList();

        public DisjunctionMaxWeight(IndexSearcher searcher) throws IOException {
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(disjunctQuery.createWeight(searcher));
            }
        }

        @Override
        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float max2 = 0.0f;
            float sum2 = 0.0f;
            for (Weight currentWeight : this.weights) {
                float sub = currentWeight.getValueForNormalization();
                sum2 += sub;
                max2 = Math.max(max2, sub);
            }
            float boost = DisjunctionMaxQuery.this.getBoost();
            return ((sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max2) * boost * boost;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            topLevelBoost *= DisjunctionMaxQuery.this.getBoost();
            for (Weight wt : this.weights) {
                wt.normalize(norm, topLevelBoost);
            }
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(context, true, false, acceptDocs);
                if (subScorer == null) continue;
                scorers.add(subScorer);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            DisjunctionMaxScorer result2 = new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers.toArray(new Scorer[scorers.size()]));
            return result2;
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return this.weights.get(0).explain(context, doc);
            }
            ComplexExplanation result2 = new ComplexExplanation();
            float max2 = 0.0f;
            float sum2 = 0.0f;
            result2.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(context, doc);
                if (!e.isMatch()) continue;
                result2.setMatch(Boolean.TRUE);
                result2.addDetail(e);
                sum2 += e.getValue();
                max2 = Math.max(max2, e.getValue());
            }
            result2.setValue(max2 + (sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return result2;
        }
    }
}

