/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.builders.SpanBuilderBase;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    private final Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        SpanOrQuery spanOrQuery;
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String value2 = DOMUtils.getNonBlankTextOrFail(e);
        ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
        TokenStream ts = null;
        try {
            ts = this.analyzer.tokenStream(fieldName, value2);
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            ts.reset();
            while (ts.incrementToken()) {
                termAtt.fillBytesRef();
                SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, BytesRef.deepCopyOf(bytes)));
                clausesList.add(stq);
            }
            ts.end();
            SpanOrQuery soq = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
            soq.setBoost(DOMUtils.getAttribute(e, "boost", 1.0f));
            spanOrQuery = soq;
        }
        catch (IOException ioe) {
            try {
                throw new ParserException("IOException parsing value:" + value2);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(ts);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(ts);
        return spanOrQuery;
    }
}

