/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.FilterBuilder;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.util.Bits;
import org.w3c.dom.Element;

public class NumericRangeFilterBuilder
implements FilterBuilder {
    private static final NoMatchFilter NO_MATCH_FILTER = new NoMatchFilter();
    private boolean strictMode = false;

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public Filter getFilter(Element e) throws ParserException {
        String field2 = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String lowerTerm = DOMUtils.getAttributeOrFail(e, "lowerTerm");
        String upperTerm = DOMUtils.getAttributeOrFail(e, "upperTerm");
        boolean lowerInclusive = DOMUtils.getAttribute(e, "includeLower", true);
        boolean upperInclusive = DOMUtils.getAttribute(e, "includeUpper", true);
        int precisionStep = DOMUtils.getAttribute(e, "precisionStep", 4);
        String type = DOMUtils.getAttribute(e, "type", "int");
        try {
            NumericRangeFilter<Number> filter2;
            if (type.equalsIgnoreCase("int")) {
                filter2 = NumericRangeFilter.newIntRange(field2, precisionStep, Integer.valueOf(lowerTerm), Integer.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type.equalsIgnoreCase("long")) {
                filter2 = NumericRangeFilter.newLongRange(field2, precisionStep, Long.valueOf(lowerTerm), Long.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type.equalsIgnoreCase("double")) {
                filter2 = NumericRangeFilter.newDoubleRange(field2, precisionStep, Double.valueOf(lowerTerm), Double.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type.equalsIgnoreCase("float")) {
                filter2 = NumericRangeFilter.newFloatRange(field2, precisionStep, Float.valueOf(lowerTerm), Float.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else {
                throw new ParserException("type attribute must be one of: [long, int, double, float]");
            }
            return filter2;
        }
        catch (NumberFormatException nfe) {
            if (this.strictMode) {
                throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
            }
            return NO_MATCH_FILTER;
        }
    }

    static class NoMatchFilter
    extends Filter {
        NoMatchFilter() {
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            return null;
        }
    }
}

