/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.nodes;

import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryparser.flexible.core.parser.EscapeQuerySyntax;

public class OpaqueQueryNode
extends QueryNodeImpl {
    private CharSequence schema = null;
    private CharSequence value = null;

    public OpaqueQueryNode(CharSequence schema, CharSequence value2) {
        this.setLeaf(true);
        this.schema = schema;
        this.value = value2;
    }

    @Override
    public String toString() {
        return "<opaque schema='" + this.schema + "' value='" + this.value + "'/>";
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        return "@" + this.schema + ":'" + this.value + "'";
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        OpaqueQueryNode clone2 = (OpaqueQueryNode)super.cloneTree();
        clone2.schema = this.schema;
        clone2.value = this.value;
        return clone2;
    }

    public CharSequence getSchema() {
        return this.schema;
    }

    public CharSequence getValue() {
        return this.value;
    }
}

