/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import org.apache.lucene.queryparser.classic.FieldQueryExtension;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MissingFieldQueryExtension
implements FieldQueryExtension {
    public static final String NAME = "_missing_";

    @Override
    public Query query(QueryParseContext parseContext, String queryText) {
        String fieldName = queryText;
        Filter filter2 = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            filter2 = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true, parseContext);
        }
        if (filter2 == null) {
            filter2 = new TermRangeFilter(fieldName, null, null, true, true);
        }
        filter2 = parseContext.cacheFilter(filter2, null);
        filter2 = new NotFilter(filter2);
        filter2 = parseContext.cacheFilter(filter2, null);
        filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartNameFieldMappers, parseContext);
        return new XConstantScoreQuery(filter2);
    }
}

