/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.lucene.Lucene;

public class XSimpleQueryParser
extends QueryBuilder {
    protected final Map<String, Float> weights;
    protected final int flags;
    public static final int AND_OPERATOR = 1;
    public static final int NOT_OPERATOR = 2;
    public static final int OR_OPERATOR = 4;
    public static final int PREFIX_OPERATOR = 8;
    public static final int PHRASE_OPERATOR = 16;
    public static final int PRECEDENCE_OPERATORS = 32;
    public static final int ESCAPE_OPERATOR = 64;
    public static final int WHITESPACE_OPERATOR = 128;
    private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XSimpleQueryParser(Analyzer analyzer, String field2) {
        this(analyzer, Collections.singletonMap(field2, Float.valueOf(1.0f)));
    }

    public XSimpleQueryParser(Analyzer analyzer, Map<String, Float> weights) {
        this(analyzer, weights, -1);
    }

    public XSimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags) {
        super(analyzer);
        this.weights = weights;
        this.flags = flags;
    }

    public Query parse(String queryText) {
        char[] data2 = queryText.toCharArray();
        char[] buffer = new char[data2.length];
        State state = new State(data2, buffer, 0, data2.length);
        this.parseSubQuery(state);
        return state.top;
    }

    private void parseSubQuery(State state) {
        while (state.index < state.length) {
            if (state.data[state.index] == '(' && (this.flags & 0x20) != 0) {
                this.consumeSubQuery(state);
            } else if (state.data[state.index] == ')' && (this.flags & 0x20) != 0) {
                ++state.index;
            } else if (state.data[state.index] == '\"' && (this.flags & 0x10) != 0) {
                this.consumePhrase(state);
            } else if (state.data[state.index] == '+' && (this.flags & 1) != 0) {
                if (state.currentOperation == null && state.top != null) {
                    state.currentOperation = BooleanClause.Occur.MUST;
                }
                ++state.index;
            } else if (state.data[state.index] == '|' && (this.flags & 4) != 0) {
                if (state.currentOperation == null && state.top != null) {
                    state.currentOperation = BooleanClause.Occur.SHOULD;
                }
                ++state.index;
            } else {
                if (state.data[state.index] == '-' && (this.flags & 2) != 0) {
                    ++state.not;
                    ++state.index;
                    continue;
                }
                if ((state.data[state.index] == ' ' || state.data[state.index] == '\t' || state.data[state.index] == '\n' || state.data[state.index] == '\r') && (this.flags & 0x80) != 0) {
                    ++state.index;
                } else {
                    this.consumeToken(state);
                }
            }
            state.not = 0;
        }
    }

    private void consumeSubQuery(State state) {
        if (!$assertionsDisabled && (this.flags & 0x20) == 0) {
            throw new AssertionError();
        }
        int start = ++state.index;
        int precedence = 1;
        boolean escaped = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    ++state.index;
                    continue;
                }
                if (state.data[state.index] == '(') {
                    ++precedence;
                } else if (state.data[state.index] == ')' && --precedence == 0) break;
            }
            escaped = false;
            ++state.index;
        }
        if (state.index == state.length) {
            state.index = start;
        } else if (state.index == start) {
            state.currentOperation = null;
            ++state.index;
        } else {
            State subState = new State(state.data, state.buffer, start, state.index);
            this.parseSubQuery(subState);
            this.buildQueryTree(state, subState.top);
            ++state.index;
        }
    }

    private void consumePhrase(State state) {
        if (!$assertionsDisabled && (this.flags & 0x10) == 0) {
            throw new AssertionError();
        }
        int start = ++state.index;
        int copied = 0;
        boolean escaped = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    ++state.index;
                    continue;
                }
                if (state.data[state.index] == '\"') break;
            }
            escaped = false;
            state.buffer[copied++] = state.data[state.index++];
        }
        if (state.index == state.length) {
            state.index = start;
        } else if (state.index == start) {
            state.currentOperation = null;
            ++state.index;
        } else {
            String phrase2 = new String(state.buffer, 0, copied);
            Query branch = this.newPhraseQuery(phrase2);
            this.buildQueryTree(state, branch);
            ++state.index;
        }
    }

    private void consumeToken(State state) {
        int copied = 0;
        boolean escaped = false;
        boolean prefix = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    prefix = false;
                    ++state.index;
                    continue;
                }
                if (state.data[state.index] == '\"' && (this.flags & 0x10) != 0 || state.data[state.index] == '|' && (this.flags & 4) != 0 || state.data[state.index] == '+' && (this.flags & 1) != 0 || state.data[state.index] == '(' && (this.flags & 0x20) != 0 || state.data[state.index] == ')' && (this.flags & 0x20) != 0 || (state.data[state.index] == ' ' || state.data[state.index] == '\t' || state.data[state.index] == '\n' || state.data[state.index] == '\r') && (this.flags & 0x80) != 0) break;
                prefix = copied > 0 && state.data[state.index] == '*' && (this.flags & 8) != 0;
            }
            escaped = false;
            state.buffer[copied++] = state.data[state.index++];
        }
        if (copied > 0) {
            Query branch;
            if (prefix) {
                String token2 = new String(state.buffer, 0, copied - 1);
                branch = this.newPrefixQuery(token2);
            } else {
                String token3 = new String(state.buffer, 0, copied);
                branch = this.newDefaultQuery(token3);
            }
            this.buildQueryTree(state, branch);
        }
    }

    private void buildQueryTree(State state, Query branch) {
        if (branch != null) {
            if (state.not % 2 == 1) {
                BooleanQuery nq = new BooleanQuery();
                nq.add(branch, BooleanClause.Occur.MUST_NOT);
                nq.add(new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
                branch = nq;
            }
            if (state.top == null) {
                state.top = branch;
            } else {
                if (state.currentOperation == null) {
                    state.currentOperation = this.defaultOperator;
                }
                if (state.previousOperation != state.currentOperation) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(state.top, state.currentOperation);
                    state.top = bq;
                }
                ((BooleanQuery)state.top).add(branch, state.currentOperation);
                state.previousOperation = state.currentOperation;
            }
            state.currentOperation = null;
        }
    }

    protected Query newDefaultQuery(String text2) {
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry<String, Float> entry2 : this.weights.entrySet()) {
            Query q = this.createBooleanQuery(entry2.getKey(), text2, this.defaultOperator);
            if (q == null) continue;
            q.setBoost(entry2.getValue().floatValue());
            bq.add(q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq);
    }

    protected Query newPhraseQuery(String text2) {
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry<String, Float> entry2 : this.weights.entrySet()) {
            Query q = this.createPhraseQuery(entry2.getKey(), text2);
            if (q == null) continue;
            q.setBoost(entry2.getValue().floatValue());
            bq.add(q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq);
    }

    protected Query newPrefixQuery(String text2) {
        BooleanQuery bq = new BooleanQuery(true);
        for (Map.Entry<String, Float> entry2 : this.weights.entrySet()) {
            PrefixQuery prefix = new PrefixQuery(new Term(entry2.getKey(), text2));
            prefix.setBoost(entry2.getValue().floatValue());
            bq.add(prefix, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq);
    }

    protected Query simplify(BooleanQuery bq) {
        if (bq.clauses().isEmpty()) {
            return null;
        }
        if (bq.clauses().size() == 1) {
            return bq.clauses().get(0).getQuery();
        }
        return bq;
    }

    public BooleanClause.Occur getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        this.defaultOperator = operator;
    }

    static {
        boolean bl = $assertionsDisabled = !XSimpleQueryParser.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Version.LUCENE_46.onOrAfter(Lucene.VERSION)) {
            throw new AssertionError((Object)"Lucene 4.7 adds SimpleQueryParser, remove me!");
        }
    }

    static class State {
        final char[] data;
        final char[] buffer;
        int index;
        int length;
        BooleanClause.Occur currentOperation;
        BooleanClause.Occur previousOperation;
        int not;
        Query top;

        State(char[] data2, char[] buffer, int index, int length) {
            this.data = data2;
            this.buffer = buffer;
            this.index = index;
            this.length = length;
        }
    }
}

