/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public class EnumFieldSource
extends FieldCacheSource {
    static final Integer DEFAULT_VALUE = -1;
    final FieldCache.IntParser parser;
    final Map<Integer, String> enumIntToStringMap;
    final Map<String, Integer> enumStringToIntMap;

    public EnumFieldSource(String field2, FieldCache.IntParser parser, Map<Integer, String> enumIntToStringMap, Map<String, Integer> enumStringToIntMap) {
        super(field2);
        this.parser = parser;
        this.enumIntToStringMap = enumIntToStringMap;
        this.enumStringToIntMap = enumStringToIntMap;
    }

    private static Integer tryParseInt(String valueStr) {
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    private String intValueToStringValue(Integer intVal) {
        if (intVal == null) {
            return null;
        }
        String enumString = this.enumIntToStringMap.get(intVal);
        if (enumString != null) {
            return enumString;
        }
        return DEFAULT_VALUE.toString();
    }

    private Integer stringValueToIntValue(String stringVal2) {
        String enumString;
        if (stringVal2 == null) {
            return null;
        }
        Integer enumInt = this.enumStringToIntMap.get(stringVal2);
        if (enumInt != null) {
            return enumInt;
        }
        Integer intValue = EnumFieldSource.tryParseInt(stringVal2);
        if (intValue == null) {
            intValue = DEFAULT_VALUE;
        }
        if ((enumString = this.enumIntToStringMap.get(intValue)) != null) {
            return intValue;
        }
        return DEFAULT_VALUE;
    }

    @Override
    public String description() {
        return "enum(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FieldCache.Ints arr = this.cache.getInts(readerContext.reader(), this.field, this.parser, true);
        final Bits valid = this.cache.getDocsWithField(readerContext.reader(), this.field);
        return new IntDocValues(this){
            final MutableValueInt val;
            {
                super(x0);
                this.val = new MutableValueInt();
            }

            @Override
            public float floatVal(int doc) {
                return arr.get(doc);
            }

            @Override
            public int intVal(int doc) {
                return arr.get(doc);
            }

            @Override
            public long longVal(int doc) {
                return arr.get(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return arr.get(doc);
            }

            @Override
            public String strVal(int doc) {
                Integer intValue = arr.get(doc);
                return EnumFieldSource.this.intValueToStringValue(intValue);
            }

            @Override
            public Object objectVal(int doc) {
                return valid.get(doc) ? Integer.valueOf(arr.get(doc)) : null;
            }

            @Override
            public boolean exists(int doc) {
                return valid.get(doc);
            }

            @Override
            public String toString(int doc) {
                return EnumFieldSource.this.description() + '=' + this.strVal(doc);
            }

            @Override
            public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
                Integer n;
                Integer n2;
                Integer lower = EnumFieldSource.this.stringValueToIntValue(lowerVal);
                Integer upper = EnumFieldSource.this.stringValueToIntValue(upperVal);
                if (lower == null) {
                    lower = Integer.MIN_VALUE;
                } else if (!includeLower && lower < Integer.MAX_VALUE) {
                    n2 = lower;
                    n = lower = Integer.valueOf(lower + 1);
                }
                if (upper == null) {
                    upper = Integer.MAX_VALUE;
                } else if (!includeUpper && upper > Integer.MIN_VALUE) {
                    n2 = upper;
                    n = upper = Integer.valueOf(upper - 1);
                }
                final int ll = lower;
                final int uu = upper;
                return new ValueSourceScorer(reader, this){

                    @Override
                    public boolean matchesValue(int doc) {
                        int val = arr.get(doc);
                        return val >= ll && val <= uu;
                    }
                };
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = arr.get(doc);
                        this.mval.exists = valid.get(doc);
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumFieldSource that = (EnumFieldSource)o;
        if (!((Object)this.enumIntToStringMap).equals(that.enumIntToStringMap)) {
            return false;
        }
        if (!((Object)this.enumStringToIntMap).equals(that.enumStringToIntMap)) {
            return false;
        }
        return this.parser.equals(that.parser);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.parser.hashCode();
        result2 = 31 * result2 + ((Object)this.enumIntToStringMap).hashCode();
        result2 = 31 * result2 + ((Object)this.enumStringToIntMap).hashCode();
        return result2;
    }
}

