/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;

public class ChainedFilter
extends Filter {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANDNOT = 2;
    public static final int XOR = 3;
    public static final int DEFAULT = 0;
    private Filter[] chain = null;
    private int[] logicArray;
    private int logic = -1;

    public ChainedFilter(Filter[] chain2) {
        this.chain = chain2;
    }

    public ChainedFilter(Filter[] chain2, int[] logicArray) {
        this.chain = chain2;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain2, int logic) {
        this.chain = chain2;
        this.logic = logic;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        int[] index = new int[]{0};
        if (this.logic != -1) {
            return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, this.logic, index), acceptDocs);
        }
        if (this.logicArray != null) {
            return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, this.logicArray, index), acceptDocs);
        }
        return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, 0, index), acceptDocs);
    }

    private DocIdSetIterator getDISI(Filter filter2, AtomicReaderContext context) throws IOException {
        DocIdSet docIdSet = filter2.getDocIdSet(context, null);
        if (docIdSet == null) {
            return DocIdSetIterator.empty();
        }
        DocIdSetIterator iter2 = docIdSet.iterator();
        if (iter2 == null) {
            return DocIdSetIterator.empty();
        }
        return iter2;
    }

    private OpenBitSetDISI initialResult(AtomicReaderContext context, int logic, int[] index) throws IOException {
        OpenBitSetDISI result2;
        AtomicReader reader = context.reader();
        if (logic == 1) {
            result2 = new OpenBitSetDISI(this.getDISI(this.chain[index[0]], context), reader.maxDoc());
            index[0] = index[0] + 1;
        } else if (logic == 2) {
            result2 = new OpenBitSetDISI(this.getDISI(this.chain[index[0]], context), reader.maxDoc());
            result2.flip(0L, reader.maxDoc());
            index[0] = index[0] + 1;
        } else {
            result2 = new OpenBitSetDISI(reader.maxDoc());
        }
        return result2;
    }

    private DocIdSet getDocIdSet(AtomicReaderContext context, int logic, int[] index) throws IOException {
        OpenBitSetDISI result2 = this.initialResult(context, logic, index);
        while (index[0] < this.chain.length) {
            this.doChain(result2, logic, this.chain[index[0]].getDocIdSet(context, null));
            index[0] = index[0] + 1;
        }
        return result2;
    }

    private DocIdSet getDocIdSet(AtomicReaderContext context, int[] logic, int[] index) throws IOException {
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        OpenBitSetDISI result2 = this.initialResult(context, logic[0], index);
        while (index[0] < this.chain.length) {
            this.doChain(result2, logic[index[0]], this.chain[index[0]].getDocIdSet(context, null));
            index[0] = index[0] + 1;
        }
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChainedFilter: [");
        for (Filter aChain : this.chain) {
            sb.append(aChain);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(OpenBitSetDISI result2, int logic, DocIdSet dis) throws IOException {
        if (dis instanceof OpenBitSet) {
            switch (logic) {
                case 0: {
                    result2.or((OpenBitSet)dis);
                    break;
                }
                case 1: {
                    result2.and((OpenBitSet)dis);
                    break;
                }
                case 2: {
                    result2.andNot((OpenBitSet)dis);
                    break;
                }
                case 3: {
                    result2.xor((OpenBitSet)dis);
                    break;
                }
                default: {
                    this.doChain(result2, 0, dis);
                    break;
                }
            }
        } else {
            DocIdSetIterator disi;
            if (dis == null) {
                disi = DocIdSetIterator.empty();
            } else {
                disi = dis.iterator();
                if (disi == null) {
                    disi = DocIdSetIterator.empty();
                }
            }
            switch (logic) {
                case 0: {
                    result2.inPlaceOr(disi);
                    break;
                }
                case 1: {
                    result2.inPlaceAnd(disi);
                    break;
                }
                case 2: {
                    result2.inPlaceNot(disi);
                    break;
                }
                case 3: {
                    result2.inPlaceXor(disi);
                    break;
                }
                default: {
                    this.doChain(result2, 0, dis);
                }
            }
        }
    }
}

