/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class HighFreqTerms {
    public static final int DEFAULT_NUMTERMS = 100;

    public static void main(String[] args) throws Exception {
        String field2 = null;
        int numTerms = 100;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        FSDirectory dir = FSDirectory.open(new File(args[0]));
        Comparator<TermStats> comparator = new DocFreqComparator();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                comparator = new TotalTermFreqComparator();
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                field2 = args[i];
            }
        }
        DirectoryReader reader = DirectoryReader.open(dir);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader, numTerms, field2, comparator);
        for (int i = 0; i < terms.length; ++i) {
            System.out.printf("%s:%s \t totalTF = %,d \t docFreq = %,d \n", terms[i].field, terms[i].termtext.utf8ToString(), terms[i].totalTermFreq, terms[i].docFreq);
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t] [number_terms] [field]\n\t -t: order by totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader, int numTerms, String field2, Comparator<TermStats> comparator) throws Exception {
        Fields fields;
        TermStatsQueue tiq = null;
        if (field2 != null) {
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                throw new RuntimeException("field " + field2 + " not found");
            }
            Terms terms = fields.terms(field2);
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator(null);
                tiq = new TermStatsQueue(numTerms, comparator);
                tiq.fill(field2, termsEnum);
            }
        } else {
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                throw new RuntimeException("no fields found for this index");
            }
            tiq = new TermStatsQueue(numTerms, comparator);
            for (String fieldName : fields) {
                Terms terms = fields.terms(fieldName);
                if (terms == null) continue;
                tiq.fill(fieldName, terms.iterator(null));
            }
        }
        TermStats[] result2 = new TermStats[tiq.size()];
        int count2 = tiq.size() - 1;
        while (tiq.size() != 0) {
            result2[count2] = (TermStats)tiq.pop();
            --count2;
        }
        return result2;
    }

    static final class TermStatsQueue
    extends PriorityQueue<TermStats> {
        final Comparator<TermStats> comparator;

        TermStatsQueue(int size2, Comparator<TermStats> comparator) {
            super(size2);
            this.comparator = comparator;
        }

        @Override
        protected boolean lessThan(TermStats termInfoA, TermStats termInfoB) {
            return this.comparator.compare(termInfoA, termInfoB) < 0;
        }

        protected void fill(String field2, TermsEnum termsEnum) throws IOException {
            BytesRef term = null;
            while ((term = termsEnum.next()) != null) {
                this.insertWithOverflow(new TermStats(field2, term, termsEnum.docFreq(), termsEnum.totalTermFreq()));
            }
        }
    }

    public static final class TotalTermFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res;
            if (a.totalTermFreq == b.totalTermFreq) {
                res = a.field.compareTo(b.field);
                if (res == 0) {
                    res = a.termtext.compareTo(b.termtext);
                }
            } else {
                res = a.totalTermFreq > b.totalTermFreq ? 1 : -1;
            }
            return res;
        }
    }

    public static final class DocFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res = Long.signum(a.docFreq - b.docFreq);
            if (res == 0 && (res = a.field.compareTo(b.field)) == 0) {
                res = a.termtext.compareTo(b.termtext);
            }
            return res;
        }
    }
}

