/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SortedDocValuesTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public abstract class SortedDocValues
extends BinaryDocValues {
    public static final SortedDocValues EMPTY = new SortedDocValues(){

        @Override
        public int getOrd(int docID) {
            return -1;
        }

        @Override
        public void lookupOrd(int ord, BytesRef result2) {
            result2.bytes = BytesRef.EMPTY_BYTES;
            result2.offset = 0;
            result2.length = 0;
        }

        @Override
        public int getValueCount() {
            return 0;
        }
    };

    protected SortedDocValues() {
    }

    public abstract int getOrd(int var1);

    public abstract void lookupOrd(int var1, BytesRef var2);

    public abstract int getValueCount();

    @Override
    public void get(int docID, BytesRef result2) {
        int ord = this.getOrd(docID);
        if (ord == -1) {
            result2.bytes = BytesRef.EMPTY_BYTES;
            result2.length = 0;
            result2.offset = 0;
        } else {
            this.lookupOrd(ord, result2);
        }
    }

    public int lookupTerm(BytesRef key) {
        BytesRef spare = new BytesRef();
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            this.lookupOrd(mid, spare);
            int cmp = spare.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public TermsEnum termsEnum() {
        return new SortedDocValuesTermsEnum(this);
    }
}

