/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericFieldUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MutableBits;

class ReadersAndUpdates {
    public final SegmentCommitInfo info;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final IndexWriter writer;
    private SegmentReader reader;
    private SegmentReader mergeReader;
    private Bits liveDocs;
    private int pendingDeleteCount;
    private boolean liveDocsShared;
    private boolean isMerging = false;
    private final Map<String, NumericFieldUpdates> mergingNumericUpdates = new HashMap<String, NumericFieldUpdates>();

    public ReadersAndUpdates(IndexWriter writer, SegmentCommitInfo info) {
        this.info = info;
        this.writer = writer;
        this.liveDocsShared = true;
    }

    public void incRef() {
        int rc = this.refCount.incrementAndGet();
        assert (rc > 1);
    }

    public void decRef() {
        int rc = this.refCount.decrementAndGet();
        assert (rc >= 0);
    }

    public int refCount() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc;
    }

    public synchronized int getPendingDeleteCount() {
        return this.pendingDeleteCount;
    }

    public synchronized boolean verifyDocCounts() {
        int count2;
        if (this.liveDocs != null) {
            count2 = 0;
            for (int docID = 0; docID < this.info.info.getDocCount(); ++docID) {
                if (!this.liveDocs.get(docID)) continue;
                ++count2;
            }
        } else {
            count2 = this.info.info.getDocCount();
        }
        assert (this.info.info.getDocCount() - this.info.getDelCount() - this.pendingDeleteCount == count2) : "info.docCount=" + this.info.info.getDocCount() + " info.getDelCount()=" + this.info.getDelCount() + " pendingDeleteCount=" + this.pendingDeleteCount + " count=" + count2;
        return true;
    }

    public SegmentReader getReader(IOContext context) throws IOException {
        if (this.reader == null) {
            this.reader = new SegmentReader(this.info, this.writer.getConfig().getReaderTermsIndexDivisor(), context);
            if (this.liveDocs == null) {
                this.liveDocs = this.reader.getLiveDocs();
            }
        }
        this.reader.incRef();
        return this.reader;
    }

    public synchronized SegmentReader getMergeReader(IOContext context) throws IOException {
        if (this.mergeReader == null) {
            if (this.reader != null) {
                this.reader.incRef();
                this.mergeReader = this.reader;
            } else {
                this.mergeReader = new SegmentReader(this.info, -1, context);
                if (this.liveDocs == null) {
                    this.liveDocs = this.mergeReader.getLiveDocs();
                }
            }
        }
        this.mergeReader.incRef();
        return this.mergeReader;
    }

    public synchronized void release(SegmentReader sr) throws IOException {
        assert (this.info == sr.getSegmentInfo());
        sr.decRef();
    }

    public synchronized boolean delete(int docID) {
        assert (this.liveDocs != null);
        assert (Thread.holdsLock(this.writer));
        assert (docID >= 0 && docID < this.liveDocs.length()) : "out of bounds: docid=" + docID + " liveDocsLength=" + this.liveDocs.length() + " seg=" + this.info.info.name + " docCount=" + this.info.info.getDocCount();
        assert (!this.liveDocsShared);
        boolean didDelete = this.liveDocs.get(docID);
        if (didDelete) {
            ((MutableBits)this.liveDocs).clear(docID);
            ++this.pendingDeleteCount;
        }
        return didDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropReaders() throws IOException {
        block12: {
            try {
                if (this.reader == null) break block12;
                try {
                    this.reader.decRef();
                }
                finally {
                    this.reader = null;
                }
            }
            finally {
                if (this.mergeReader != null) {
                    try {
                        this.mergeReader.decRef();
                    }
                    finally {
                        this.mergeReader = null;
                    }
                }
            }
        }
        this.decRef();
    }

    public synchronized SegmentReader getReadOnlyClone(IOContext context) throws IOException {
        if (this.reader == null) {
            this.getReader(context).decRef();
            assert (this.reader != null);
        }
        this.liveDocsShared = true;
        if (this.liveDocs != null) {
            return new SegmentReader(this.reader.getSegmentInfo(), this.reader, this.liveDocs, this.info.info.getDocCount() - this.info.getDelCount() - this.pendingDeleteCount);
        }
        assert (this.reader.getLiveDocs() == this.liveDocs);
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void initWritableLiveDocs() throws IOException {
        assert (Thread.holdsLock(this.writer));
        assert (this.info.info.getDocCount() > 0);
        if (this.liveDocsShared) {
            LiveDocsFormat liveDocsFormat = this.info.info.getCodec().liveDocsFormat();
            this.liveDocs = this.liveDocs == null ? liveDocsFormat.newLiveDocs(this.info.info.getDocCount()) : liveDocsFormat.newLiveDocs(this.liveDocs);
            this.liveDocsShared = false;
        }
    }

    public synchronized Bits getLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        return this.liveDocs;
    }

    public synchronized Bits getReadOnlyLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        this.liveDocsShared = true;
        return this.liveDocs;
    }

    public synchronized void dropChanges() {
        this.pendingDeleteCount = 0;
        this.dropMergingUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeLiveDocs(Directory dir) throws IOException {
        assert (Thread.holdsLock(this.writer));
        if (this.pendingDeleteCount == 0) {
            return false;
        }
        assert (this.liveDocs.length() == this.info.info.getDocCount());
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
        boolean success2 = false;
        try {
            Codec codec = this.info.info.getCodec();
            codec.liveDocsFormat().writeLiveDocs((MutableBits)this.liveDocs, trackingDir, this.info, this.pendingDeleteCount, IOContext.DEFAULT);
            success2 = true;
        }
        finally {
            if (!success2) {
                this.info.advanceNextWriteDelGen();
                for (String fileName : trackingDir.getCreatedFiles()) {
                    try {
                        dir.deleteFile(fileName);
                    }
                    catch (Throwable t) {}
                }
            }
        }
        this.info.advanceDelGen();
        this.info.setDelCount(this.info.getDelCount() + this.pendingDeleteCount);
        this.pendingDeleteCount = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeFieldUpdates(Directory dir, Map<String, NumericFieldUpdates> numericFieldUpdates) throws IOException {
        FieldInfos fieldInfos;
        TrackingDirectoryWrapper trackingDir;
        block37: {
            assert (Thread.holdsLock(this.writer));
            assert (numericFieldUpdates != null && !numericFieldUpdates.isEmpty());
            trackingDir = new TrackingDirectoryWrapper(dir);
            fieldInfos = null;
            boolean success2 = false;
            try {
                block36: {
                    Codec codec = this.info.info.getCodec();
                    final SegmentReader segmentReader = this.reader == null ? new SegmentReader(this.info, this.writer.getConfig().getReaderTermsIndexDivisor(), IOContext.READONCE) : this.reader;
                    try {
                        DocValuesConsumer fieldsConsumer;
                        block35: {
                            FieldInfos.Builder builder = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
                            for (FieldInfo fi : segmentReader.getFieldInfos()) {
                                FieldInfo clone2 = builder.add(fi);
                                if (fi.attributes() != null) {
                                    for (Map.Entry<String, String> e : fi.attributes().entrySet()) {
                                        clone2.putAttribute(e.getKey(), e.getValue());
                                    }
                                }
                                clone2.setDocValuesGen(fi.getDocValuesGen());
                            }
                            for (String f2 : numericFieldUpdates.keySet()) {
                                builder.addOrUpdate(f2, NumericDocValuesField.TYPE);
                            }
                            fieldInfos = builder.finish();
                            long nextFieldInfosGen = this.info.getNextFieldInfosGen();
                            String segmentSuffix = Long.toString(nextFieldInfosGen, 36);
                            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, this.writer.getConfig().getTermIndexInterval(), null, IOContext.DEFAULT, segmentSuffix);
                            DocValuesFormat docValuesFormat = codec.docValuesFormat();
                            fieldsConsumer = docValuesFormat.fieldsConsumer(state);
                            boolean fieldsConsumerSuccess = false;
                            try {
                                for (Map.Entry<String, NumericFieldUpdates> e : numericFieldUpdates.entrySet()) {
                                    final String field2 = e.getKey();
                                    final NumericFieldUpdates fieldUpdates = e.getValue();
                                    FieldInfo fieldInfo = fieldInfos.fieldInfo(field2);
                                    assert (fieldInfo != null);
                                    fieldInfo.setDocValuesGen(nextFieldInfosGen);
                                    fieldsConsumer.addNumericField(fieldInfo, new Iterable<Number>(){
                                        final NumericDocValues currentValues;
                                        final Bits docsWithField;
                                        final int maxDoc;
                                        final NumericFieldUpdates.UpdatesIterator updatesIter;
                                        {
                                            this.currentValues = segmentReader.getNumericDocValues(field2);
                                            this.docsWithField = segmentReader.getDocsWithField(field2);
                                            this.maxDoc = segmentReader.maxDoc();
                                            this.updatesIter = fieldUpdates.getUpdates();
                                        }

                                        @Override
                                        public Iterator<Number> iterator() {
                                            this.updatesIter.reset();
                                            return new Iterator<Number>(){
                                                int curDoc = -1;
                                                int updateDoc;
                                                {
                                                    this.updateDoc = updatesIter.nextDoc();
                                                }

                                                @Override
                                                public boolean hasNext() {
                                                    return this.curDoc < maxDoc - 1;
                                                }

                                                @Override
                                                public Number next() {
                                                    if (++this.curDoc >= maxDoc) {
                                                        throw new NoSuchElementException("no more documents to return values for");
                                                    }
                                                    if (this.curDoc == this.updateDoc) {
                                                        Long value2 = updatesIter.value();
                                                        this.updateDoc = updatesIter.nextDoc();
                                                        return value2;
                                                    }
                                                    assert (this.curDoc < this.updateDoc);
                                                    if (currentValues != null && docsWithField.get(this.curDoc)) {
                                                        return currentValues.get(this.curDoc);
                                                    }
                                                    return null;
                                                }

                                                @Override
                                                public void remove() {
                                                    throw new UnsupportedOperationException("this iterator does not support removing elements");
                                                }
                                            };
                                        }
                                    });
                                }
                                codec.fieldInfosFormat().getFieldInfosWriter().write(trackingDir, this.info.info.name, segmentSuffix, fieldInfos, IOContext.DEFAULT);
                                fieldsConsumerSuccess = true;
                                if (!fieldsConsumerSuccess) break block35;
                            }
                            catch (Throwable throwable) {
                                if (fieldsConsumerSuccess) {
                                    fieldsConsumer.close();
                                } else {
                                    IOUtils.closeWhileHandlingException(fieldsConsumer);
                                }
                                throw throwable;
                            }
                            fieldsConsumer.close();
                            break block36;
                        }
                        IOUtils.closeWhileHandlingException(fieldsConsumer);
                    }
                    finally {
                        if (segmentReader != this.reader) {
                            segmentReader.close();
                        }
                    }
                }
                success2 = true;
                if (success2) break block37;
                this.info.advanceNextWriteFieldInfosGen();
            }
            catch (Throwable throwable) {
                if (!success2) {
                    this.info.advanceNextWriteFieldInfosGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        try {
                            dir.deleteFile(fileName);
                        }
                        catch (Throwable t) {}
                    }
                }
                throw throwable;
            }
            for (String string2 : trackingDir.getCreatedFiles()) {
                try {
                    dir.deleteFile(string2);
                }
                catch (Throwable t) {}
            }
        }
        this.info.advanceFieldInfosGen();
        if (this.isMerging) {
            for (Map.Entry entry2 : numericFieldUpdates.entrySet()) {
                NumericFieldUpdates fieldUpdates = this.mergingNumericUpdates.get(entry2.getKey());
                if (fieldUpdates == null) {
                    this.mergingNumericUpdates.put((String)entry2.getKey(), (NumericFieldUpdates)entry2.getValue());
                    continue;
                }
                fieldUpdates.merge((NumericFieldUpdates)entry2.getValue());
            }
        }
        Map<Long, Set<String>> genUpdatesFiles = this.info.getUpdatesFiles();
        HashMap<Long, Set<String>> hashMap = new HashMap<Long, Set<String>>();
        long fieldInfosGen = this.info.getFieldInfosGen();
        for (FieldInfo fi : fieldInfos) {
            long dvGen = fi.getDocValuesGen();
            if (dvGen == -1L || hashMap.containsKey(dvGen)) continue;
            if (dvGen == fieldInfosGen) {
                hashMap.put(fieldInfosGen, trackingDir.getCreatedFiles());
                continue;
            }
            hashMap.put(dvGen, genUpdatesFiles.get(dvGen));
        }
        this.info.setGenUpdatesFiles(hashMap);
        this.writer.checkpoint();
        if (this.reader != null) {
            SegmentReader newReader = new SegmentReader(this.info, this.reader, this.liveDocs, this.info.info.getDocCount() - this.info.getDelCount() - this.pendingDeleteCount);
            boolean reopened = false;
            try {
                this.reader.decRef();
                this.reader = newReader;
                reopened = true;
            }
            finally {
                if (!reopened) {
                    newReader.decRef();
                }
            }
        }
    }

    synchronized SegmentReader getReaderForMerge(IOContext context) throws IOException {
        assert (Thread.holdsLock(this.writer));
        this.isMerging = true;
        return this.getReader(context);
    }

    public synchronized void dropMergingUpdates() {
        this.mergingNumericUpdates.clear();
        this.isMerging = false;
    }

    public synchronized Map<String, NumericFieldUpdates> getMergingFieldUpdates() {
        return this.mergingNumericUpdates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReadersAndLiveDocs(seg=").append(this.info);
        sb.append(" pendingDeleteCount=").append(this.pendingDeleteCount);
        sb.append(" liveDocsShared=").append(this.liveDocsShared);
        return sb.toString();
    }
}

