/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public class PKIndexSplitter {
    private final Filter docsInFirstIndex;
    private final Directory input;
    private final Directory dir1;
    private final Directory dir2;
    private final IndexWriterConfig config1;
    private final IndexWriterConfig config2;

    public PKIndexSplitter(Version version, Directory input2, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this(input2, dir1, dir2, docsInFirstIndex, PKIndexSplitter.newDefaultConfig(version), PKIndexSplitter.newDefaultConfig(version));
    }

    private static IndexWriterConfig newDefaultConfig(Version version) {
        return new IndexWriterConfig(version, null).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
    }

    public PKIndexSplitter(Directory input2, Directory dir1, Directory dir2, Filter docsInFirstIndex, IndexWriterConfig config1, IndexWriterConfig config2) {
        this.input = input2;
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.docsInFirstIndex = docsInFirstIndex;
        this.config1 = config1;
        this.config2 = config2;
    }

    public PKIndexSplitter(Version version, Directory input2, Directory dir1, Directory dir2, Term midTerm) {
        this(version, input2, dir1, dir2, new TermRangeFilter(midTerm.field(), null, midTerm.bytes(), true, false));
    }

    public PKIndexSplitter(Directory input2, Directory dir1, Directory dir2, Term midTerm, IndexWriterConfig config1, IndexWriterConfig config2) {
        this(input2, dir1, dir2, new TermRangeFilter(midTerm.field(), null, midTerm.bytes(), true, false), config1, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        block5: {
            DirectoryReader reader;
            block4: {
                boolean success2 = false;
                reader = DirectoryReader.open(this.input);
                try {
                    this.createIndex(this.config1, this.dir1, reader, this.docsInFirstIndex, false);
                    this.createIndex(this.config2, this.dir2, reader, this.docsInFirstIndex, true);
                    success2 = true;
                    if (!success2) break block4;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(reader);
                    } else {
                        IOUtils.closeWhileHandlingException(reader);
                    }
                    throw throwable;
                }
                IOUtils.close(reader);
                break block5;
            }
            IOUtils.closeWhileHandlingException(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(IndexWriterConfig config, Directory target, IndexReader reader, Filter preserveFilter, boolean negateFilter) throws IOException {
        block6: {
            IndexWriter w;
            block5: {
                boolean success2 = false;
                w = new IndexWriter(target, config);
                try {
                    List<AtomicReaderContext> leaves = reader.leaves();
                    IndexReader[] subReaders = new IndexReader[leaves.size()];
                    int i = 0;
                    for (AtomicReaderContext ctx : leaves) {
                        subReaders[i++] = new DocumentFilteredAtomicIndexReader(ctx, preserveFilter, negateFilter);
                    }
                    w.addIndexes(subReaders);
                    success2 = true;
                    if (!success2) break block5;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(w);
                    } else {
                        IOUtils.closeWhileHandlingException(w);
                    }
                    throw throwable;
                }
                IOUtils.close(w);
                break block6;
            }
            IOUtils.closeWhileHandlingException(w);
        }
    }

    private static class DocumentFilteredAtomicIndexReader
    extends FilterAtomicReader {
        final Bits liveDocs;
        final int numDocs;

        public DocumentFilteredAtomicIndexReader(AtomicReaderContext context, Filter preserveFilter, boolean negateFilter) throws IOException {
            super(context.reader());
            DocIdSetIterator it;
            int maxDoc = this.in.maxDoc();
            FixedBitSet bits2 = new FixedBitSet(maxDoc);
            DocIdSet docs = preserveFilter.getDocIdSet(context, null);
            if (docs != null && (it = docs.iterator()) != null) {
                bits2.or(it);
            }
            if (negateFilter) {
                bits2.flip(0, maxDoc);
            }
            if (this.in.hasDeletions()) {
                Bits oldLiveDocs = this.in.getLiveDocs();
                assert (oldLiveDocs != null);
                DocIdSetIterator it2 = bits2.iterator();
                int i = it2.nextDoc();
                while (i < maxDoc) {
                    if (!oldLiveDocs.get(i)) {
                        bits2.clear(i);
                    }
                    i = it2.nextDoc();
                }
            }
            this.liveDocs = bits2;
            this.numDocs = bits2.cardinality();
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

