/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.Term;
import org.apache.lucene.util.RamUsageEstimator;

final class NumericUpdate {
    private static final int RAW_SIZE_IN_BYTES = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32 + 8;
    static final Long MISSING = new Long(0L);
    Term term;
    String field;
    Long value;
    int docIDUpto = -1;

    NumericUpdate(Term term, String field2, Long value2) {
        this.term = term;
        this.field = field2;
        this.value = value2 == null ? MISSING : value2;
    }

    int sizeInBytes() {
        int sizeInBytes2 = RAW_SIZE_IN_BYTES;
        sizeInBytes2 += this.term.field.length() * 2;
        sizeInBytes2 += this.term.bytes.bytes.length;
        return sizeInBytes2 += this.field.length() * 2;
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.value;
    }
}

