/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.NumericUpdate;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

interface NumericFieldUpdates {
    public void add(int var1, Long var2);

    public UpdatesIterator getUpdates();

    public void merge(NumericFieldUpdates var1);

    public static final class PackedNumericFieldUpdates
    implements NumericFieldUpdates {
        private FixedBitSet docsWithField = new FixedBitSet(64);
        private PagedMutable docs;
        private PagedGrowableWriter values;
        private int size;

        public PackedNumericFieldUpdates(int maxDoc) {
            this.docs = new PagedMutable(1L, 1024, PackedInts.bitsRequired(maxDoc - 1), 0.0f);
            this.values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
            this.size = 0;
        }

        @Override
        public void add(int doc, Long value2) {
            assert (value2 != null);
            if (this.size == Integer.MAX_VALUE) {
                throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
            }
            if (this.docs.size() == (long)this.size) {
                this.docs = (PagedMutable)this.docs.grow(this.size + 1);
                this.values = (PagedGrowableWriter)this.values.grow(this.size + 1);
                int numWords = (int)(this.docs.size() >> 6);
                if (this.docsWithField.getBits().length <= numWords) {
                    numWords = ArrayUtil.oversize(numWords + 1, 8);
                    this.docsWithField = new FixedBitSet(this.docsWithField, numWords << 6);
                }
            }
            if (value2 != NumericUpdate.MISSING) {
                this.docsWithField.set(this.size);
            }
            this.docs.set(this.size, doc);
            this.values.set(this.size, value2);
            ++this.size;
        }

        @Override
        public UpdatesIterator getUpdates() {
            final PagedMutable docs = this.docs;
            final PagedGrowableWriter values2 = this.values;
            final FixedBitSet docsWithField = this.docsWithField;
            new InPlaceMergeSorter(){

                @Override
                protected void swap(int i, int j) {
                    long tmpDoc = docs.get(j);
                    docs.set(j, docs.get(i));
                    docs.set(i, tmpDoc);
                    long tmpVal = values2.get(j);
                    values2.set(j, values2.get(i));
                    values2.set(i, tmpVal);
                    boolean tmpBool = docsWithField.get(j);
                    if (docsWithField.get(i)) {
                        docsWithField.set(j);
                    } else {
                        docsWithField.clear(j);
                    }
                    if (tmpBool) {
                        docsWithField.set(i);
                    } else {
                        docsWithField.clear(i);
                    }
                }

                @Override
                protected int compare(int i, int j) {
                    int y;
                    int x2 = (int)docs.get(i);
                    return x2 < (y = (int)docs.get(j)) ? -1 : (x2 == y ? 0 : 1);
                }
            }.sort(0, this.size);
            final int size2 = this.size;
            return new UpdatesIterator(){
                private long idx = 0L;
                private int doc = -1;
                private Long value = null;

                @Override
                Long value() {
                    return this.value;
                }

                @Override
                int nextDoc() {
                    if (this.idx >= (long)size2) {
                        this.value = null;
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = (int)docs.get(this.idx);
                    ++this.idx;
                    while (this.idx < (long)size2 && docs.get(this.idx) == (long)this.doc) {
                        ++this.idx;
                    }
                    this.value = !docsWithField.get((int)(this.idx - 1L)) ? null : Long.valueOf(values2.get(this.idx - 1L));
                    return this.doc;
                }

                @Override
                int doc() {
                    return this.doc;
                }

                @Override
                void reset() {
                    this.doc = -1;
                    this.value = null;
                    this.idx = 0L;
                }
            };
        }

        @Override
        public void merge(NumericFieldUpdates other) {
            if (other instanceof PackedNumericFieldUpdates) {
                PackedNumericFieldUpdates packedOther = (PackedNumericFieldUpdates)other;
                if (this.size + packedOther.size > Integer.MAX_VALUE) {
                    throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + packedOther.size);
                }
                this.docs = (PagedMutable)this.docs.grow(this.size + packedOther.size);
                this.values = (PagedGrowableWriter)this.values.grow(this.size + packedOther.size);
                int numWords = (int)(this.docs.size() >> 6);
                if (this.docsWithField.getBits().length <= numWords) {
                    numWords = ArrayUtil.oversize(numWords + 1, 8);
                    this.docsWithField = new FixedBitSet(this.docsWithField, numWords << 6);
                }
                for (int i = 0; i < packedOther.size; ++i) {
                    int doc = (int)packedOther.docs.get(i);
                    if (packedOther.docsWithField.get(i)) {
                        this.docsWithField.set(this.size);
                    }
                    this.docs.set(this.size, doc);
                    this.values.set(this.size, packedOther.values.get(i));
                    ++this.size;
                }
            } else {
                int doc;
                UpdatesIterator iter2 = other.getUpdates();
                while ((doc = iter2.nextDoc()) != Integer.MAX_VALUE) {
                    Long value2 = iter2.value();
                    if (value2 == null) {
                        value2 = NumericUpdate.MISSING;
                    }
                    this.add(doc, value2);
                }
            }
        }
    }

    public static abstract class UpdatesIterator {
        abstract int nextDoc();

        abstract int doc();

        abstract Long value();

        abstract void reset();
    }
}

