/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.AppendingDeltaPackedLongBuffer;

class NumericDocValuesWriter
extends DocValuesWriter {
    private static final long MISSING = 0L;
    private AppendingDeltaPackedLongBuffer pending = new AppendingDeltaPackedLongBuffer(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final OpenBitSet docsWithField = new OpenBitSet();
    private final FieldInfo fieldInfo;
    private final boolean trackDocsWithField;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed, boolean trackDocsWithField) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
        this.trackDocsWithField = trackDocsWithField;
    }

    public void addValue(int docID, long value2) {
        if ((long)docID < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        for (int i = (int)this.pending.size(); i < docID; ++i) {
            this.pending.add(0L);
        }
        this.pending.add(value2);
        if (this.trackDocsWithField) {
            this.docsWithField.set(docID);
        }
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void finish(int maxDoc) {
    }

    @Override
    public void flush(SegmentWriteState state, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.getDocCount();
        dvConsumer.addNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new NumericIterator(maxDoc);
            }
        });
    }

    @Override
    public void abort() {
    }

    private class NumericIterator
    implements Iterator<Number> {
        final AbstractAppendingLongBuffer.Iterator iter;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int maxDoc) {
            this.iter = NumericDocValuesWriter.this.pending.iterator();
            this.size = (int)NumericDocValuesWriter.this.pending.size();
            this.maxDoc = maxDoc;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            Long value2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                long v = this.iter.next();
                value2 = !NumericDocValuesWriter.this.trackDocsWithField || NumericDocValuesWriter.this.docsWithField.get(this.upto) ? Long.valueOf(v) : null;
            } else {
                value2 = NumericDocValuesWriter.this.trackDocsWithField ? null : Long.valueOf(0L);
            }
            ++this.upto;
            return value2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

