/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getNormValues(field2);
        }
        FieldInfo fi = MultiFields.getMergedFieldInfos(r).fieldInfo(field2);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        boolean anyReal = false;
        final NumericDocValues[] values2 = new NumericDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNormValues(field2);
            if (v == null) {
                v = NumericDocValues.EMPTY;
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        assert (anyReal);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                return values2[subIndex].get(docID - starts2[subIndex]);
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getNumericDocValues(field2);
        }
        boolean anyReal = false;
        final NumericDocValues[] values2 = new NumericDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNumericDocValues(field2);
            if (v == null) {
                v = NumericDocValues.EMPTY;
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                return values2[subIndex].get(docID - starts2[subIndex]);
            }
        };
    }

    public static Bits getDocsWithField(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getDocsWithField(field2);
        }
        boolean anyReal = false;
        boolean anyMissing = false;
        Bits[] values2 = new Bits[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            Bits v = context.reader().getDocsWithField(field2);
            if (v == null) {
                v = new Bits.MatchNoBits(context.reader().maxDoc());
                anyMissing = true;
            } else {
                anyReal = true;
                if (!(v instanceof Bits.MatchAllBits)) {
                    anyMissing = true;
                }
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        if (!anyMissing) {
            return new Bits.MatchAllBits(r.maxDoc());
        }
        return new MultiBits(values2, starts2, false);
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getBinaryDocValues(field2);
        }
        boolean anyReal = false;
        final BinaryDocValues[] values2 = new BinaryDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            BinaryDocValues v = context.reader().getBinaryDocValues(field2);
            if (v == null) {
                v = BinaryDocValues.EMPTY;
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result2) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                values2[subIndex].get(docID - starts2[subIndex], result2);
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getSortedDocValues(field2);
        }
        boolean anyReal = false;
        SortedDocValues[] values2 = new SortedDocValues[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field2);
            if (v == null) {
                v = SortedDocValues.EMPTY;
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        TermsEnum[] enums = new TermsEnum[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            enums[i] = values2[i].termsEnum();
        }
        OrdinalMap mapping = new OrdinalMap(r.getCoreCacheKey(), enums);
        return new MultiSortedDocValues(values2, starts2, mapping);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field2) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field2);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values2 = new SortedSetDocValues[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            AtomicReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field2);
            if (v == null) {
                v = SortedSetDocValues.EMPTY;
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        TermsEnum[] enums = new TermsEnum[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            enums[i] = values2[i].termsEnum();
        }
        OrdinalMap mapping = new OrdinalMap(r.getCoreCacheKey(), enums);
        return new MultiSortedSetDocValues(values2, starts2, mapping);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        int currentSubIndex;

        MultiSortedSetDocValues(SortedSetDocValues[] values2, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (values2.length == mapping.ordDeltas.length);
            assert (docStarts.length == values2.length + 1);
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public long nextOrd() {
            long segmentOrd = this.values[this.currentSubIndex].nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.mapping.getGlobalOrd(this.currentSubIndex, segmentOrd);
        }

        @Override
        public void setDocument(int docID) {
            this.currentSubIndex = ReaderUtil.subIndex(docID, this.docStarts);
            this.values[this.currentSubIndex].setDocument(docID - this.docStarts[this.currentSubIndex]);
        }

        @Override
        public void lookupOrd(long ord, BytesRef result2) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            this.values[subIndex].lookupOrd(segmentOrd, result2);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;

        MultiSortedDocValues(SortedDocValues[] values2, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (values2.length == mapping.ordDeltas.length);
            assert (docStarts.length == values2.length + 1);
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public int getOrd(int docID) {
            int subIndex = ReaderUtil.subIndex(docID, this.docStarts);
            int segmentOrd = this.values[subIndex].getOrd(docID - this.docStarts[subIndex]);
            return segmentOrd == -1 ? segmentOrd : (int)this.mapping.getGlobalOrd(subIndex, segmentOrd);
        }

        @Override
        public void lookupOrd(int ord, BytesRef result2) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            this.values[subIndex].lookupOrd(segmentOrd, result2);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }
    }

    public static class OrdinalMap {
        final Object owner;
        final MonotonicAppendingLongBuffer globalOrdDeltas;
        final AppendingPackedLongBuffer firstSegments;
        final MonotonicAppendingLongBuffer[] ordDeltas;

        public OrdinalMap(Object owner, TermsEnum[] subs) throws IOException {
            this.owner = owner;
            this.globalOrdDeltas = new MonotonicAppendingLongBuffer(0.0f);
            this.firstSegments = new AppendingPackedLongBuffer(0.0f);
            this.ordDeltas = new MonotonicAppendingLongBuffer[subs.length];
            for (int i = 0; i < this.ordDeltas.length; ++i) {
                this.ordDeltas[i] = new MonotonicAppendingLongBuffer();
            }
            long[] segmentOrds = new long[subs.length];
            ReaderSlice[] slices = new ReaderSlice[subs.length];
            MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = new ReaderSlice(0, 0, i);
                indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[i], i);
            }
            MultiTermsEnum mte = new MultiTermsEnum(slices);
            mte.reset(indexes);
            long globalOrd = 0L;
            while (mte.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] matches2 = mte.getMatchArray();
                for (int i = 0; i < mte.getMatchCount(); ++i) {
                    int segmentIndex = matches2[i].index;
                    long segmentOrd = matches2[i].terms.ord();
                    long delta = globalOrd - segmentOrd;
                    if (i == 0) {
                        this.firstSegments.add(segmentIndex);
                        this.globalOrdDeltas.add(delta);
                    }
                    while (segmentOrds[segmentIndex] <= segmentOrd) {
                        this.ordDeltas[segmentIndex].add(delta);
                        int n = segmentIndex;
                        segmentOrds[n] = segmentOrds[n] + 1L;
                    }
                }
                ++globalOrd;
            }
            this.firstSegments.freeze();
            this.globalOrdDeltas.freeze();
            for (int i = 0; i < this.ordDeltas.length; ++i) {
                this.ordDeltas[i].freeze();
            }
        }

        public long getGlobalOrd(int segmentIndex, long segmentOrd) {
            return segmentOrd + this.ordDeltas[segmentIndex].get(segmentOrd);
        }

        public long getFirstSegmentOrd(long globalOrd) {
            return globalOrd - this.globalOrdDeltas.get(globalOrd);
        }

        public int getFirstSegmentNumber(long globalOrd) {
            return (int)this.firstSegments.get(globalOrd);
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        public long ramBytesUsed() {
            long size2 = this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed();
            for (int i = 0; i < this.ordDeltas.length; ++i) {
                size2 += this.ordDeltas[i].ramBytesUsed();
            }
            return size2;
        }
    }
}

