/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Iterator;
import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.util.InfoStream;

abstract class FlushPolicy
implements Cloneable {
    protected LiveIndexWriterConfig indexWriterConfig;
    protected InfoStream infoStream;

    FlushPolicy() {
    }

    public abstract void onDelete(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    public void onUpdate(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState state) {
        this.onInsert(control, state);
        this.onDelete(control, state);
    }

    public abstract void onInsert(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    protected synchronized void init(LiveIndexWriterConfig indexWriterConfig) {
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = indexWriterConfig.getInfoStream();
    }

    protected DocumentsWriterPerThreadPool.ThreadState findLargestNonPendingWriter(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState perThreadState) {
        assert (perThreadState.dwpt.getNumDocsInRAM() > 0);
        long maxRamSoFar = perThreadState.bytesUsed;
        DocumentsWriterPerThreadPool.ThreadState maxRamUsingThreadState = perThreadState;
        assert (!perThreadState.flushPending) : "DWPT should have flushed";
        Iterator<DocumentsWriterPerThreadPool.ThreadState> activePerThreadsIterator = control.allActiveThreadStates();
        while (activePerThreadsIterator.hasNext()) {
            long nextRam;
            DocumentsWriterPerThreadPool.ThreadState next2 = activePerThreadsIterator.next();
            if (next2.flushPending || (nextRam = next2.bytesUsed) <= maxRamSoFar || next2.dwpt.getNumDocsInRAM() <= 0) continue;
            maxRamSoFar = nextRam;
            maxRamUsingThreadState = next2;
        }
        assert (this.assertMessage("set largest ram consuming thread pending on lower watermark"));
        return maxRamUsingThreadState;
    }

    private boolean assertMessage(String s) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", s);
        }
        return true;
    }

    public FlushPolicy clone() {
        FlushPolicy clone2;
        try {
            clone2 = (FlushPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone2.indexWriterConfig = null;
        clone2.infoStream = null;
        return clone2;
    }
}

