/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.SortField;

public final class SimpleBindings
extends Bindings {
    final Map<String, Object> map = new HashMap<String, Object>();

    public void add(SortField sortField) {
        this.map.put(sortField.getField(), sortField);
    }

    public void add(String name, Expression expression) {
        this.map.put(name, expression);
    }

    @Override
    public ValueSource getValueSource(String name) {
        Object o = this.map.get(name);
        if (o == null) {
            throw new IllegalArgumentException("Invalid reference '" + name + "'");
        }
        if (o instanceof Expression) {
            return ((Expression)o).getValueSource(this);
        }
        SortField field2 = (SortField)o;
        switch (field2.getType()) {
            case INT: {
                return new IntFieldSource(field2.getField(), (FieldCache.IntParser)field2.getParser());
            }
            case LONG: {
                return new LongFieldSource(field2.getField(), (FieldCache.LongParser)field2.getParser());
            }
            case FLOAT: {
                return new FloatFieldSource(field2.getField(), (FieldCache.FloatParser)field2.getParser());
            }
            case DOUBLE: {
                return new DoubleFieldSource(field2.getField(), (FieldCache.DoubleParser)field2.getParser());
            }
            case SCORE: {
                return this.getScoreValueSource();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void validate() {
        for (Object o : this.map.values()) {
            if (!(o instanceof Expression)) continue;
            Expression expr = (Expression)o;
            try {
                expr.getValueSource(this);
            }
            catch (StackOverflowError e) {
                throw new IllegalArgumentException("Recursion Error: Cycle detected originating in (" + expr.sourceText + ")");
            }
        }
    }
}

