/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.ExpressionComparator;
import org.apache.lucene.expressions.ExpressionValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;

class ExpressionSortField
extends SortField {
    private final ExpressionValueSource source;

    ExpressionSortField(String name, ExpressionValueSource source, boolean reverse2) {
        super(name, SortField.Type.CUSTOM, reverse2);
        this.source = source;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        return new ExpressionComparator(this.source, numHits);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.source == null ? 0 : this.source.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionSortField other = (ExpressionSortField)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<expr \"");
        buffer.append(this.getField());
        buffer.append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        return buffer.toString();
    }

    @Override
    public boolean needsScores() {
        return this.source.needsScores();
    }
}

