/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import org.apache.lucene.expressions.Expression;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;

class ExpressionFunctionValues
extends DoubleDocValues {
    final Expression expression;
    final FunctionValues[] functionValues;
    int currentDocument = -1;
    double currentValue;

    ExpressionFunctionValues(ValueSource parent, Expression expression, FunctionValues[] functionValues) {
        super(parent);
        if (expression == null) {
            throw new NullPointerException();
        }
        if (functionValues == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.functionValues = functionValues;
    }

    @Override
    public double doubleVal(int document2) {
        if (this.currentDocument != document2) {
            this.currentDocument = document2;
            this.currentValue = this.expression.evaluate(document2, this.functionValues);
        }
        return this.currentValue;
    }
}

