/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;

public class CompressionTools {
    private CompressionTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] value2, int offset, int length, int compressionLevel) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Deflater compressor = new Deflater();
        try {
            compressor.setLevel(compressionLevel);
            compressor.setInput(value2, offset, length);
            compressor.finish();
            byte[] buf = new byte[1024];
            while (!compressor.finished()) {
                int count2 = compressor.deflate(buf);
                bos.write(buf, 0, count2);
            }
        }
        finally {
            compressor.end();
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] value2, int offset, int length) {
        return CompressionTools.compress(value2, offset, length, 9);
    }

    public static byte[] compress(byte[] value2) {
        return CompressionTools.compress(value2, 0, value2.length, 9);
    }

    public static byte[] compressString(String value2) {
        return CompressionTools.compressString(value2, 9);
    }

    public static byte[] compressString(String value2, int compressionLevel) {
        BytesRef result2 = new BytesRef();
        UnicodeUtil.UTF16toUTF8(value2, 0, value2.length(), result2);
        return CompressionTools.compress(result2.bytes, 0, result2.length, compressionLevel);
    }

    public static byte[] decompress(BytesRef bytes) throws DataFormatException {
        return CompressionTools.decompress(bytes.bytes, bytes.offset, bytes.length);
    }

    public static byte[] decompress(byte[] value2) throws DataFormatException {
        return CompressionTools.decompress(value2, 0, value2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] value2, int offset, int length) throws DataFormatException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Inflater decompressor = new Inflater();
        try {
            decompressor.setInput(value2, offset, length);
            byte[] buf = new byte[1024];
            while (!decompressor.finished()) {
                int count2 = decompressor.inflate(buf);
                bos.write(buf, 0, count2);
            }
        }
        finally {
            decompressor.end();
        }
        return bos.toByteArray();
    }

    public static String decompressString(byte[] value2) throws DataFormatException {
        return CompressionTools.decompressString(value2, 0, value2.length);
    }

    public static String decompressString(byte[] value2, int offset, int length) throws DataFormatException {
        byte[] bytes = CompressionTools.decompress(value2, offset, length);
        CharsRef result2 = new CharsRef(bytes.length);
        UnicodeUtil.UTF8toUTF16(bytes, 0, bytes.length, result2);
        return new String(result2.chars, 0, result2.length);
    }

    public static String decompressString(BytesRef bytes) throws DataFormatException {
        return CompressionTools.decompressString(bytes.bytes, bytes.offset, bytes.length);
    }
}

