/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

class SimpleTextDocValuesReader
extends DocValuesProducer {
    final int maxDoc;
    final IndexInput data;
    final BytesRef scratch;
    final Map<String, OneField> fields;

    public SimpleTextDocValuesReader(SegmentReadState state, String ext) throws IOException {
        block15: {
            this.scratch = new BytesRef();
            this.fields = new HashMap<String, OneField>();
            this.data = state.directory.openInput(IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, ext), state.context);
            this.maxDoc = state.segmentInfo.getDocCount();
            while (true) {
                this.readLine();
                if (this.scratch.equals(SimpleTextDocValuesWriter.END)) break block15;
                assert (this.startsWith(SimpleTextDocValuesWriter.FIELD)) : this.scratch.utf8ToString();
                String fieldName = this.stripPrefix(SimpleTextDocValuesWriter.FIELD);
                OneField field2 = new OneField();
                this.fields.put(fieldName, field2);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.TYPE)) : this.scratch.utf8ToString();
                FieldInfo.DocValuesType dvType = FieldInfo.DocValuesType.valueOf(this.stripPrefix(SimpleTextDocValuesWriter.TYPE));
                assert (dvType != null);
                if (dvType == FieldInfo.DocValuesType.NUMERIC) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MINVALUE)) : "got " + this.scratch.utf8ToString() + " field=" + fieldName + " ext=" + ext;
                    field2.minValue = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.MINVALUE));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field2.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((1 + field2.pattern.length() + 2) * this.maxDoc));
                    continue;
                }
                if (dvType == FieldInfo.DocValuesType.BINARY) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                    field2.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field2.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * this.maxDoc));
                    continue;
                }
                if (dvType != FieldInfo.DocValuesType.SORTED && dvType != FieldInfo.DocValuesType.SORTED_SET) break;
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.NUMVALUES));
                field2.numValues = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.NUMVALUES));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                field2.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.ORDPATTERN));
                field2.ordPattern = this.stripPrefix(SimpleTextDocValuesWriter.ORDPATTERN);
                field2.dataStartFilePointer = this.data.getFilePointer();
                this.data.seek(this.data.getFilePointer() + (long)(9 + field2.pattern.length() + field2.maxLength) * field2.numValues + (long)((1 + field2.ordPattern.length()) * this.maxDoc));
            }
            throw new AssertionError();
        }
        assert (!this.fields.isEmpty());
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        assert (field2 != null) : "field=" + fieldInfo.name + " fields=" + this.fields;
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder2 = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        decoder2.setParseBigDecimal(true);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                try {
                    BigDecimal bd;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field2.dataStartFilePointer + (long)((1 + field2.pattern.length() + 2) * docID));
                    SimpleTextUtil.readLine(in, scratch);
                    try {
                        bd = (BigDecimal)decoder2.parse(scratch.utf8ToString());
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse BigDecimal value (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                    SimpleTextUtil.readLine(in, scratch);
                    return BigInteger.valueOf(field2.minValue).add(bd.toBigIntegerExact()).longValue();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getNumericDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    in.seek(field2.dataStartFilePointer + (long)((1 + field2.pattern.length() + 2) * index));
                    SimpleTextUtil.readLine(in, scratch);
                    SimpleTextUtil.readLine(in, scratch);
                    return scratch.bytes[scratch.offset] == 84;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder2 = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result2) {
                try {
                    int len;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field2.dataStartFilePointer + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * docID));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder2.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                    result2.bytes = new byte[len];
                    result2.offset = 0;
                    result2.length = len;
                    in.readBytes(result2.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getBinaryDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder2 = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    int len;
                    in.seek(field2.dataStartFilePointer + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * index));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder2.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                    byte[] bytes = new byte[len];
                    in.readBytes(bytes, 0, len);
                    SimpleTextUtil.readLine(in, scratch);
                    SimpleTextUtil.readLine(in, scratch);
                    return scratch.bytes[scratch.offset] == 84;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder2 = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DecimalFormat ordDecoder = new DecimalFormat(field2.ordPattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field2.dataStartFilePointer + field2.numValues * (long)(9 + field2.pattern.length() + field2.maxLength) + (long)(docID * (1 + field2.ordPattern.length())));
                    SimpleTextUtil.readLine(in, scratch);
                    try {
                        return (int)ordDecoder.parse(scratch.utf8ToString()).longValue() - 1;
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse ord (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                try {
                    int len;
                    if (ord < 0 || (long)ord >= field2.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field2.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field2.dataStartFilePointer + (long)(ord * (9 + field2.pattern.length() + field2.maxLength)));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.utf8ToString() + " in=" + in;
                    try {
                        len = decoder2.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                    result2.bytes = new byte[len];
                    result2.offset = 0;
                    result2.length = len;
                    in.readBytes(result2.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int getValueCount() {
                return (int)field2.numValues;
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in = this.data.clone();
        final BytesRef scratch = new BytesRef();
        final DecimalFormat decoder2 = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedSetDocValues(){
            String[] currentOrds = new String[0];
            int currentIndex = 0;

            @Override
            public long nextOrd() {
                if (this.currentIndex == this.currentOrds.length) {
                    return -1L;
                }
                return Long.parseLong(this.currentOrds[this.currentIndex++]);
            }

            @Override
            public void setDocument(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field2.dataStartFilePointer + field2.numValues * (long)(9 + field2.pattern.length() + field2.maxLength) + (long)(docID * (1 + field2.ordPattern.length())));
                    SimpleTextUtil.readLine(in, scratch);
                    String ordList = scratch.utf8ToString().trim();
                    this.currentOrds = ordList.isEmpty() ? new String[0] : ordList.split(",");
                    this.currentIndex = 0;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public void lookupOrd(long ord, BytesRef result2) {
                try {
                    int len;
                    if (ord < 0L || ord >= field2.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field2.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field2.dataStartFilePointer + ord * (long)(9 + field2.pattern.length() + field2.maxLength));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.utf8ToString() + " in=" + in;
                    try {
                        len = decoder2.parse(new String(scratch.bytes, scratch.offset + SimpleTextDocValuesWriter.LENGTH.length, scratch.length - SimpleTextDocValuesWriter.LENGTH.length, "UTF-8")).intValue();
                    }
                    catch (ParseException pe) {
                        CorruptIndexException e = new CorruptIndexException("failed to parse int length (resource=" + in + ")");
                        e.initCause(pe);
                        throw e;
                    }
                    result2.bytes = new byte[len];
                    result2.offset = 0;
                    result2.length = len;
                    in.readBytes(result2.bytes, 0, len);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public long getValueCount() {
                return field2.numValues;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                return this.getBinaryDocsWithField(field2);
            }
            case NUMERIC: {
                return this.getNumericDocsWithField(field2);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.data, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith(this.scratch, prefix);
    }

    private String stripPrefix(BytesRef prefix) throws IOException {
        return new String(this.scratch.bytes, this.scratch.offset + prefix.length, this.scratch.length - prefix.length, "UTF-8");
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    static class OneField {
        long dataStartFilePointer;
        String pattern;
        String ordPattern;
        int maxLength;
        boolean fixedLength;
        long minValue;
        long numValues;

        OneField() {
        }
    }
}

