/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.pulsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;

public final class PulsingPostingsWriter
extends PostingsWriterBase {
    static final String CODEC = "PulsedPostingsWriter";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private IndexOutput termsOut;
    private FieldInfo.IndexOptions indexOptions;
    private boolean storePayloads;
    private final List<PendingTerm> pendingTerms = new ArrayList<PendingTerm>();
    private final Position[] pending;
    private int pendingCount = 0;
    private Position currentDoc;
    final PostingsWriterBase wrappedPostingsWriter;
    private boolean DEBUG;
    private final RAMOutputStream buffer = new RAMOutputStream();

    public PulsingPostingsWriter(int maxPositions, PostingsWriterBase wrappedPostingsWriter) {
        this.pending = new Position[maxPositions];
        for (int i = 0; i < maxPositions; ++i) {
            this.pending[i] = new Position();
        }
        this.wrappedPostingsWriter = wrappedPostingsWriter;
    }

    @Override
    public void start(IndexOutput termsOut) throws IOException {
        this.termsOut = termsOut;
        CodecUtil.writeHeader(termsOut, CODEC, 0);
        termsOut.writeVInt(this.pending.length);
        this.wrappedPostingsWriter.start(termsOut);
    }

    @Override
    public void startTerm() {
        assert (this.pendingCount == 0);
    }

    @Override
    public void setField(FieldInfo fieldInfo) {
        this.indexOptions = fieldInfo.getIndexOptions();
        this.storePayloads = fieldInfo.hasPayloads();
        this.wrappedPostingsWriter.setField(fieldInfo);
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        assert (docID >= 0) : "got docID=" + docID;
        if (this.pendingCount == this.pending.length) {
            this.push();
            this.wrappedPostingsWriter.finishDoc();
        }
        if (this.pendingCount != -1) {
            assert (this.pendingCount < this.pending.length);
            this.currentDoc = this.pending[this.pendingCount];
            this.currentDoc.docID = docID;
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                ++this.pendingCount;
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                ++this.pendingCount;
                this.currentDoc.termFreq = termDocFreq;
            } else {
                this.currentDoc.termFreq = termDocFreq;
            }
        } else {
            this.wrappedPostingsWriter.startDoc(docID, termDocFreq);
        }
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (this.pendingCount == this.pending.length) {
            this.push();
        }
        if (this.pendingCount == -1) {
            this.wrappedPostingsWriter.addPosition(position, payload, startOffset, endOffset);
        } else {
            Position pos = this.pending[this.pendingCount++];
            pos.pos = position;
            pos.startOffset = startOffset;
            pos.endOffset = endOffset;
            pos.docID = this.currentDoc.docID;
            if (payload != null && payload.length > 0) {
                if (pos.payload == null) {
                    pos.payload = BytesRef.deepCopyOf(payload);
                } else {
                    pos.payload.copyBytes(payload);
                }
            } else if (pos.payload != null) {
                pos.payload.length = 0;
            }
        }
    }

    @Override
    public void finishDoc() throws IOException {
        if (this.pendingCount == -1) {
            this.wrappedPostingsWriter.finishDoc();
        }
    }

    @Override
    public void finishTerm(TermStats stats) throws IOException {
        assert (this.pendingCount > 0 || this.pendingCount == -1);
        if (this.pendingCount == -1) {
            this.wrappedPostingsWriter.finishTerm(stats);
            this.pendingTerms.add(null);
        } else {
            int lastDocID;
            if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                lastDocID = 0;
                int pendingIDX = 0;
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                while (pendingIDX < this.pendingCount) {
                    Position doc = this.pending[pendingIDX];
                    int delta = doc.docID - lastDocID;
                    lastDocID = doc.docID;
                    if (doc.termFreq == 1) {
                        this.buffer.writeVInt(delta << 1 | 1);
                    } else {
                        this.buffer.writeVInt(delta << 1);
                        this.buffer.writeVInt(doc.termFreq);
                    }
                    int lastPos = 0;
                    int lastOffset = 0;
                    for (int posIDX = 0; posIDX < doc.termFreq; ++posIDX) {
                        int payloadLength;
                        Position pos = this.pending[pendingIDX++];
                        assert (pos.docID == doc.docID);
                        int posDelta = pos.pos - lastPos;
                        lastPos = pos.pos;
                        int n = payloadLength = pos.payload == null ? 0 : pos.payload.length;
                        if (this.storePayloads) {
                            if (payloadLength != lastPayloadLength) {
                                this.buffer.writeVInt(posDelta << 1 | 1);
                                this.buffer.writeVInt(payloadLength);
                                lastPayloadLength = payloadLength;
                            } else {
                                this.buffer.writeVInt(posDelta << 1);
                            }
                        } else {
                            this.buffer.writeVInt(posDelta);
                        }
                        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
                            int offsetDelta = pos.startOffset - lastOffset;
                            int offsetLength = pos.endOffset - pos.startOffset;
                            if (offsetLength != lastOffsetLength) {
                                this.buffer.writeVInt(offsetDelta << 1 | 1);
                                this.buffer.writeVInt(offsetLength);
                            } else {
                                this.buffer.writeVInt(offsetDelta << 1);
                            }
                            lastOffset = pos.startOffset;
                            lastOffsetLength = offsetLength;
                        }
                        if (payloadLength <= 0) continue;
                        assert (this.storePayloads);
                        this.buffer.writeBytes(pos.payload.bytes, 0, pos.payload.length);
                    }
                }
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                lastDocID = 0;
                for (int posIDX = 0; posIDX < this.pendingCount; ++posIDX) {
                    Position doc = this.pending[posIDX];
                    int delta = doc.docID - lastDocID;
                    assert (doc.termFreq != 0);
                    if (doc.termFreq == 1) {
                        this.buffer.writeVInt(delta << 1 | 1);
                    } else {
                        this.buffer.writeVInt(delta << 1);
                        this.buffer.writeVInt(doc.termFreq);
                    }
                    lastDocID = doc.docID;
                }
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                lastDocID = 0;
                for (int posIDX = 0; posIDX < this.pendingCount; ++posIDX) {
                    Position doc = this.pending[posIDX];
                    this.buffer.writeVInt(doc.docID - lastDocID);
                    lastDocID = doc.docID;
                }
            }
            byte[] bytes = new byte[(int)this.buffer.getFilePointer()];
            this.buffer.writeTo(bytes, 0);
            this.pendingTerms.add(new PendingTerm(bytes));
            this.buffer.reset();
        }
        this.pendingCount = 0;
    }

    @Override
    public void close() throws IOException {
        this.wrappedPostingsWriter.close();
    }

    @Override
    public void flushTermsBlock(int start, int count2) throws IOException {
        int wrappedCount = 0;
        assert (this.buffer.getFilePointer() == 0L);
        assert (start >= count2);
        int limit = this.pendingTerms.size() - start + count2;
        for (int idx = this.pendingTerms.size() - start; idx < limit; ++idx) {
            PendingTerm term = this.pendingTerms.get(idx);
            if (term == null) {
                ++wrappedCount;
                continue;
            }
            this.buffer.writeVInt(term.bytes.length);
            this.buffer.writeBytes(term.bytes, 0, term.bytes.length);
        }
        this.termsOut.writeVInt((int)this.buffer.getFilePointer());
        this.buffer.writeTo(this.termsOut);
        this.buffer.reset();
        int futureWrappedCount = 0;
        int limit2 = this.pendingTerms.size();
        for (int idx = limit; idx < limit2; ++idx) {
            if (this.pendingTerms.get(idx) != null) continue;
            ++futureWrappedCount;
        }
        this.pendingTerms.subList(this.pendingTerms.size() - start, limit).clear();
        this.wrappedPostingsWriter.flushTermsBlock(futureWrappedCount + wrappedCount, wrappedCount);
    }

    private void push() throws IOException {
        assert (this.pendingCount == this.pending.length);
        this.wrappedPostingsWriter.startTerm();
        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            Position doc = null;
            for (Position pos : this.pending) {
                if (doc == null) {
                    doc = pos;
                    this.wrappedPostingsWriter.startDoc(doc.docID, doc.termFreq);
                } else if (doc.docID != pos.docID) {
                    assert (pos.docID > doc.docID);
                    this.wrappedPostingsWriter.finishDoc();
                    doc = pos;
                    this.wrappedPostingsWriter.startDoc(doc.docID, doc.termFreq);
                }
                this.wrappedPostingsWriter.addPosition(pos.pos, pos.payload, pos.startOffset, pos.endOffset);
            }
        } else {
            for (Position doc : this.pending) {
                this.wrappedPostingsWriter.startDoc(doc.docID, this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY ? 0 : doc.termFreq);
            }
        }
        this.pendingCount = -1;
    }

    private static final class Position {
        BytesRef payload;
        int termFreq;
        int pos;
        int docID;
        int startOffset;
        int endOffset;

        private Position() {
        }
    }

    private static class PendingTerm {
        private final byte[] bytes;

        public PendingTerm(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

