/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public abstract class PerFieldDocValuesFormat
extends DocValuesFormat {
    public static final String PER_FIELD_NAME = "PerFieldDV40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".suffix";

    public PerFieldDocValuesFormat() {
        super(PER_FIELD_NAME);
    }

    @Override
    public final DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new FieldsWriter(state);
    }

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    static String getFullSegmentSuffix(String outerSegmentSuffix, String segmentSuffix) {
        if (outerSegmentSuffix.length() == 0) {
            return segmentSuffix;
        }
        return outerSegmentSuffix + "_" + segmentSuffix;
    }

    @Override
    public final DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    public abstract DocValuesFormat getDocValuesFormatForField(String var1);

    private class FieldsReader
    extends DocValuesProducer {
        private final Map<String, DocValuesProducer> fields = new TreeMap<String, DocValuesProducer>();
        private final Map<String, DocValuesProducer> formats = new HashMap<String, DocValuesProducer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FieldsReader(SegmentReadState readState) throws IOException {
            boolean success2 = false;
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (!fi.hasDocValues()) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    assert (suffix != null);
                    DocValuesFormat format2 = DocValuesFormat.forName(formatName);
                    String segmentSuffix = PerFieldDocValuesFormat.getFullSegmentSuffix(readState.segmentSuffix, PerFieldDocValuesFormat.getSuffix(formatName, suffix));
                    if (!this.formats.containsKey(segmentSuffix)) {
                        this.formats.put(segmentSuffix, format2.fieldsProducer(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fieldName, this.formats.get(segmentSuffix));
                }
                success2 = true;
            }
            finally {
                if (!success2) {
                    IOUtils.closeWhileHandlingException(this.formats.values());
                }
            }
        }

        private FieldsReader(FieldsReader other) {
            IdentityHashMap<DocValuesProducer, DocValuesProducer> oldToNew = new IdentityHashMap<DocValuesProducer, DocValuesProducer>();
            for (Map.Entry<String, DocValuesProducer> ent : other.formats.entrySet()) {
                DocValuesProducer values2 = ent.getValue();
                this.formats.put(ent.getKey(), values2);
                oldToNew.put(ent.getValue(), values2);
            }
            for (Map.Entry<String, DocValuesProducer> ent : other.fields.entrySet()) {
                DocValuesProducer producer = (DocValuesProducer)oldToNew.get(ent.getValue());
                assert (producer != null);
                this.fields.put(ent.getKey(), producer);
            }
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
            DocValuesProducer producer = this.fields.get(field2.name);
            return producer == null ? null : producer.getNumeric(field2);
        }

        @Override
        public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
            DocValuesProducer producer = this.fields.get(field2.name);
            return producer == null ? null : producer.getBinary(field2);
        }

        @Override
        public SortedDocValues getSorted(FieldInfo field2) throws IOException {
            DocValuesProducer producer = this.fields.get(field2.name);
            return producer == null ? null : producer.getSorted(field2);
        }

        @Override
        public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
            DocValuesProducer producer = this.fields.get(field2.name);
            return producer == null ? null : producer.getSortedSet(field2);
        }

        @Override
        public Bits getDocsWithField(FieldInfo field2) throws IOException {
            DocValuesProducer producer = this.fields.get(field2.name);
            return producer == null ? null : producer.getDocsWithField(field2);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        public DocValuesProducer clone() {
            return new FieldsReader(this);
        }

        @Override
        public long ramBytesUsed() {
            long size2 = 0L;
            for (Map.Entry<String, DocValuesProducer> entry2 : this.formats.entrySet()) {
                size2 += (long)(entry2.getKey().length() * 2) + entry2.getValue().ramBytesUsed();
            }
            return size2;
        }
    }

    private class FieldsWriter
    extends DocValuesConsumer {
        private final Map<DocValuesFormat, ConsumerAndSuffix> formats = new HashMap<DocValuesFormat, ConsumerAndSuffix>();
        private final Map<String, Integer> suffixes = new HashMap<String, Integer>();
        private final SegmentWriteState segmentWriteState;

        public FieldsWriter(SegmentWriteState state) {
            this.segmentWriteState = state;
        }

        @Override
        public void addNumericField(FieldInfo field2, Iterable<Number> values2) throws IOException {
            this.getInstance(field2).addNumericField(field2, values2);
        }

        @Override
        public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
            this.getInstance(field2).addBinaryField(field2, values2);
        }

        @Override
        public void addSortedField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrd) throws IOException {
            this.getInstance(field2).addSortedField(field2, values2, docToOrd);
        }

        @Override
        public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            this.getInstance(field2).addSortedSetField(field2, values2, docToOrdCount, ords);
        }

        private DocValuesConsumer getInstance(FieldInfo field2) throws IOException {
            String formatName;
            DocValuesFormat format2 = null;
            if (field2.getDocValuesGen() != -1L && (formatName = field2.getAttribute(PER_FIELD_FORMAT_KEY)) != null) {
                format2 = DocValuesFormat.forName(formatName);
            }
            if (format2 == null) {
                format2 = PerFieldDocValuesFormat.this.getDocValuesFormatForField(field2.name);
            }
            if (format2 == null) {
                throw new IllegalStateException("invalid null DocValuesFormat for field=\"" + field2.name + "\"");
            }
            formatName = format2.getName();
            String previousValue = field2.putAttribute(PER_FIELD_FORMAT_KEY, formatName);
            assert (field2.getDocValuesGen() != -1L || previousValue == null) : "formatName=" + formatName + " prevValue=" + previousValue;
            Integer suffix = null;
            ConsumerAndSuffix consumer = this.formats.get(format2);
            if (consumer == null) {
                String suffixAtt;
                if (field2.getDocValuesGen() != -1L && (suffixAtt = field2.getAttribute(PER_FIELD_SUFFIX_KEY)) != null) {
                    suffix = Integer.valueOf(suffixAtt);
                }
                if (suffix == null) {
                    suffix = this.suffixes.get(formatName);
                    suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                }
                this.suffixes.put(formatName, suffix);
                String segmentSuffix = PerFieldDocValuesFormat.getFullSegmentSuffix(this.segmentWriteState.segmentSuffix, PerFieldDocValuesFormat.getSuffix(formatName, Integer.toString(suffix)));
                consumer = new ConsumerAndSuffix();
                consumer.consumer = format2.fieldsConsumer(new SegmentWriteState(this.segmentWriteState, segmentSuffix));
                consumer.suffix = suffix;
                this.formats.put(format2, consumer);
            } else {
                assert (this.suffixes.containsKey(formatName));
                suffix = consumer.suffix;
            }
            previousValue = field2.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(suffix));
            assert (field2.getDocValuesGen() != -1L || previousValue == null) : "suffix=" + Integer.toString(suffix) + " prevValue=" + previousValue;
            return consumer.consumer;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }
    }

    static class ConsumerAndSuffix
    implements Closeable {
        DocValuesConsumer consumer;
        int suffix;

        ConsumerAndSuffix() {
        }

        @Override
        public void close() throws IOException {
            this.consumer.close();
        }
    }
}

