/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, FSTEntry> fsts;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryDocValues> binaryInstances;
    private final Map<Integer, FST<Long>> fstInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final int maxDoc;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte UNCOMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 0;
    static final int VERSION_GCD_COMPRESSION = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        boolean success2;
        block8: {
            IndexInput in;
            block7: {
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryDocValues>();
                this.fstInstances = new HashMap<Integer, FST<Long>>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openInput(metaName, state.context);
                success2 = false;
                try {
                    version = CodecUtil.checkHeader(in, metaCodec, 0, 1);
                    this.numerics = new HashMap<Integer, NumericEntry>();
                    this.binaries = new HashMap<Integer, BinaryEntry>();
                    this.fsts = new HashMap<Integer, FSTEntry>();
                    this.readFields(in, state.fieldInfos);
                    success2 = true;
                    if (!success2) break block7;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        success2 = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 1);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success2 = true;
            if (success2) return;
        }
        catch (Throwable throwable) {
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry2;
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                entry2 = new NumericEntry();
                ((NumericEntry)entry2).offset = meta.readLong();
                ((NumericEntry)entry2).missingOffset = meta.readLong();
                ((NumericEntry)entry2).missingBytes = ((NumericEntry)entry2).missingOffset != -1L ? meta.readLong() : 0L;
                ((NumericEntry)entry2).format = meta.readByte();
                switch (((NumericEntry)entry2).format) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Unknown format: " + ((NumericEntry)entry2).format + ", input=" + meta);
                    }
                }
                if (((NumericEntry)entry2).format != 2) {
                    ((NumericEntry)entry2).packedIntsVersion = meta.readVInt();
                }
                this.numerics.put(fieldNumber, (NumericEntry)entry2);
            } else if (fieldType == 1) {
                entry2 = new BinaryEntry();
                ((BinaryEntry)entry2).offset = meta.readLong();
                ((BinaryEntry)entry2).numBytes = meta.readLong();
                ((BinaryEntry)entry2).missingOffset = meta.readLong();
                ((BinaryEntry)entry2).missingBytes = ((BinaryEntry)entry2).missingOffset != -1L ? meta.readLong() : 0L;
                ((BinaryEntry)entry2).minLength = meta.readVInt();
                ((BinaryEntry)entry2).maxLength = meta.readVInt();
                if (((BinaryEntry)entry2).minLength != ((BinaryEntry)entry2).maxLength) {
                    ((BinaryEntry)entry2).packedIntsVersion = meta.readVInt();
                    ((BinaryEntry)entry2).blockSize = meta.readVInt();
                }
                this.binaries.put(fieldNumber, (BinaryEntry)entry2);
            } else if (fieldType == 2) {
                entry2 = new FSTEntry();
                ((FSTEntry)entry2).offset = meta.readLong();
                ((FSTEntry)entry2).numOrds = meta.readVLong();
                this.fsts.put(fieldNumber, (FSTEntry)entry2);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field2.number);
        if (instance == null) {
            instance = this.loadNumeric(field2);
            this.numericInstances.put(field2.number, instance);
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this);
    }

    private NumericDocValues loadNumeric(FieldInfo field2) throws IOException {
        NumericEntry entry2 = this.numerics.get(field2.number);
        this.data.seek(entry2.offset + entry2.missingBytes);
        switch (entry2.format) {
            case 1: {
                int size2 = this.data.readVInt();
                if (size2 > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + this.data);
                }
                final long[] decode = new long[size2];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), entry2.packedIntsVersion, this.maxDoc, bitsPerValue);
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, entry2.packedIntsVersion, blockSize, this.maxDoc, false);
                return reader;
            }
            case 2: {
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 3: {
                final long min2 = this.data.readLong();
                final long mult = this.data.readLong();
                int quotientBlockSize = this.data.readVInt();
                final BlockPackedReader quotientReader = new BlockPackedReader(this.data, entry2.packedIntsVersion, quotientBlockSize, this.maxDoc, false);
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return min2 + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field2.number);
        if (instance == null) {
            instance = this.loadBinary(field2);
            this.binaryInstances.put(field2.number, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(FieldInfo field2) throws IOException {
        BinaryEntry entry2 = this.binaries.get(field2.number);
        this.data.seek(entry2.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry2.numBytes);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        if (entry2.minLength == entry2.maxLength) {
            final int fixedLength = entry2.minLength;
            return new BinaryDocValues(){

                @Override
                public void get(int docID, BytesRef result2) {
                    bytesReader.fillSlice(result2, (long)fixedLength * (long)docID, fixedLength);
                }
            };
        }
        this.data.seek(this.data.getFilePointer() + entry2.missingBytes);
        final MonotonicBlockPackedReader addresses = new MonotonicBlockPackedReader(this.data, entry2.packedIntsVersion, entry2.blockSize, this.maxDoc, false);
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result2) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                bytesReader.fillSlice(result2, startAddress, (int)(endAddress - startAddress));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSorted(FieldInfo field2) throws IOException {
        FST<Long> instance;
        final FSTEntry entry2 = this.fsts.get(field2.number);
        if (entry2.numOrds == 0L) {
            return SortedDocValues.EMPTY;
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field2.number);
            if (instance == null) {
                this.data.seek(entry2.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.fstInstances.put(field2.number, instance);
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field2);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output2 = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    result2.bytes = new byte[output2.length];
                    result2.offset = 0;
                    result2.length = 0;
                    Util.toBytesRef(output2, result2);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int getValueCount() {
                return (int)entry2.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        FST<Long> instance;
        final FSTEntry entry2 = this.fsts.get(field2.number);
        if (entry2.numOrds == 0L) {
            return SortedSetDocValues.EMPTY;
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field2.number);
            if (instance == null) {
                this.data.seek(entry2.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.fstInstances.put(field2.number, instance);
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field2);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        final BytesRef ref = new BytesRef();
        final ByteArrayDataInput input2 = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            long currentOrd;

            @Override
            public long nextOrd() {
                if (input2.eof()) {
                    return -1L;
                }
                this.currentOrd += input2.readVLong();
                return this.currentOrd;
            }

            @Override
            public void setDocument(int docID) {
                docToOrds.get(docID, ref);
                input2.reset(ref.bytes, ref.offset, ref.length);
                this.currentOrd = 0L;
            }

            @Override
            public void lookupOrd(long ord, BytesRef result2) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output2 = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    result2.bytes = new byte[output2.length];
                    result2.offset = 0;
                    result2.length = 0;
                    Util.toBytesRef(output2, result2);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long getValueCount() {
                return entry2.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data2 = this.data.clone();
                data2.seek(offset);
                assert (length % 8L == 0L);
                long[] bits2 = new long[(int)length >> 3];
                for (int i = 0; i < bits2.length; ++i) {
                    bits2[i] = data2.readLong();
                }
                instance = new FixedBitSet(bits2, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field2.number);
                return this.getMissingBits(field2.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field2.number);
                return this.getMissingBits(field2.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRef scratchBytes = new BytesRef();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum<Long>(fst);
            this.bytesReader = fst.getBytesReader();
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput<Long> io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
            if (this.in.seekCeil(text2) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals(text2)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public boolean seekExact(BytesRef text2) throws IOException {
            return this.in.seekExact(text2) != null;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output2 = Util.getByOutput(this.fst, ord, this.bytesReader, this.firstArc, this.scratchArc, this.scratchInts);
            this.scratchBytes.bytes = new byte[output2.length];
            this.scratchBytes.offset = 0;
            this.scratchBytes.length = 0;
            Util.toBytesRef(output2, this.scratchBytes);
            this.in.seekExact(this.scratchBytes);
        }

        @Override
        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        @Override
        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

