/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

class DirectDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedEntry> sorteds;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryDocValues> binaryInstances;
    private final Map<Integer, SortedDocValues> sortedInstances;
    private final Map<Integer, SortedSetRawValues> sortedSetInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final int maxDoc;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        boolean success2;
        block8: {
            IndexInput in;
            block7: {
                this.numerics = new HashMap<Integer, NumericEntry>();
                this.binaries = new HashMap<Integer, BinaryEntry>();
                this.sorteds = new HashMap<Integer, SortedEntry>();
                this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryDocValues>();
                this.sortedInstances = new HashMap<Integer, SortedDocValues>();
                this.sortedSetInstances = new HashMap<Integer, SortedSetRawValues>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openInput(metaName, state.context);
                success2 = false;
                try {
                    version = CodecUtil.checkHeader(in, metaCodec, 0, 0);
                    this.readFields(in);
                    success2 = true;
                    if (!success2) break block7;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        success2 = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success2 = true;
            if (success2) return;
        }
        catch (Throwable throwable) {
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry2 = new NumericEntry();
        entry2.offset = meta.readLong();
        entry2.count = meta.readInt();
        entry2.missingOffset = meta.readLong();
        entry2.missingBytes = entry2.missingOffset != -1L ? meta.readLong() : 0L;
        entry2.byteWidth = meta.readByte();
        return entry2;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry2 = new BinaryEntry();
        entry2.offset = meta.readLong();
        entry2.numBytes = meta.readInt();
        entry2.count = meta.readInt();
        entry2.missingOffset = meta.readLong();
        entry2.missingBytes = entry2.missingOffset != -1L ? meta.readLong() : 0L;
        return entry2;
    }

    private SortedEntry readSortedEntry(IndexInput meta) throws IOException {
        SortedEntry entry2 = new SortedEntry();
        entry2.docToOrd = this.readNumericEntry(meta);
        entry2.values = this.readBinaryEntry(meta);
        return entry2;
    }

    private SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry2 = new SortedSetEntry();
        entry2.docToOrdAddress = this.readNumericEntry(meta);
        entry2.ords = this.readNumericEntry(meta);
        entry2.values = this.readBinaryEntry(meta);
        return entry2;
    }

    private void readFields(IndexInput meta) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(fieldNumber, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(fieldNumber, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                this.sorteds.put(fieldNumber, this.readSortedEntry(meta));
            } else if (fieldType == 3) {
                this.sortedSets.put(fieldNumber, this.readSortedSetEntry(meta));
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this);
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field2.number);
        if (instance == null) {
            instance = this.loadNumeric(this.numerics.get(field2.number));
            this.numericInstances.put(field2.number, instance);
        }
        return instance;
    }

    private NumericDocValues loadNumeric(NumericEntry entry2) throws IOException {
        this.data.seek(entry2.offset + entry2.missingBytes);
        switch (entry2.byteWidth) {
            case 1: {
                final byte[] values2 = new byte[entry2.count];
                for (int i = 0; i < entry2.count; ++i) {
                    values2[i] = this.data.readByte();
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values2[idx];
                    }
                };
            }
            case 2: {
                final short[] values3 = new short[entry2.count];
                for (int i = 0; i < entry2.count; ++i) {
                    values3[i] = this.data.readShort();
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values3[idx];
                    }
                };
            }
            case 4: {
                final int[] values4 = new int[entry2.count];
                for (int i = 0; i < entry2.count; ++i) {
                    values4[i] = this.data.readInt();
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values4[idx];
                    }
                };
            }
            case 8: {
                final long[] values5 = new long[entry2.count];
                for (int i = 0; i < entry2.count; ++i) {
                    values5[i] = this.data.readLong();
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int idx) {
                        return values5[idx];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field2.number);
        if (instance == null) {
            instance = this.loadBinary(this.binaries.get(field2.number));
            this.binaryInstances.put(field2.number, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(BinaryEntry entry2) throws IOException {
        this.data.seek(entry2.offset);
        final byte[] bytes = new byte[entry2.numBytes];
        this.data.readBytes(bytes, 0, entry2.numBytes);
        this.data.seek(entry2.offset + (long)entry2.numBytes + entry2.missingBytes);
        final int[] address = new int[entry2.count + 1];
        for (int i = 0; i < entry2.count; ++i) {
            address[i] = this.data.readInt();
        }
        address[entry2.count] = this.data.readInt();
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result2) {
                result2.bytes = bytes;
                result2.offset = address[docID];
                result2.length = address[docID + 1] - result2.offset;
            }
        };
    }

    @Override
    public synchronized SortedDocValues getSorted(FieldInfo field2) throws IOException {
        SortedDocValues instance = this.sortedInstances.get(field2.number);
        if (instance == null) {
            instance = this.loadSorted(field2);
            this.sortedInstances.put(field2.number, instance);
        }
        return instance;
    }

    private SortedDocValues loadSorted(FieldInfo field2) throws IOException {
        final SortedEntry entry2 = this.sorteds.get(field2.number);
        final NumericDocValues docToOrd = this.loadNumeric(entry2.docToOrd);
        final BinaryDocValues values2 = this.loadBinary(entry2.values);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                values2.get(ord, result2);
            }

            @Override
            public int getValueCount() {
                return entry2.values.count;
            }
        };
    }

    @Override
    public synchronized SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        SortedSetRawValues instance = this.sortedSetInstances.get(field2.number);
        final SortedSetEntry entry2 = this.sortedSets.get(field2.number);
        if (instance == null) {
            instance = this.loadSortedSet(entry2);
            this.sortedSetInstances.put(field2.number, instance);
        }
        final NumericDocValues docToOrdAddress = instance.docToOrdAddress;
        final NumericDocValues ords = instance.ords;
        final BinaryDocValues values2 = instance.values;
        return new SortedSetDocValues(){
            int ordUpto;
            int ordLimit;

            @Override
            public long nextOrd() {
                if (this.ordUpto == this.ordLimit) {
                    return -1L;
                }
                return ords.get(this.ordUpto++);
            }

            @Override
            public void setDocument(int docID) {
                this.ordUpto = (int)docToOrdAddress.get(docID);
                this.ordLimit = (int)docToOrdAddress.get(docID + 1);
            }

            @Override
            public void lookupOrd(long ord, BytesRef result2) {
                values2.get((int)ord, result2);
            }

            @Override
            public long getValueCount() {
                return entry2.values.count;
            }
        };
    }

    private SortedSetRawValues loadSortedSet(SortedSetEntry entry2) throws IOException {
        SortedSetRawValues instance = new SortedSetRawValues();
        instance.docToOrdAddress = this.loadNumeric(entry2.docToOrdAddress);
        instance.ords = this.loadNumeric(entry2.ords);
        instance.values = this.loadBinary(entry2.values);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data2 = this.data.clone();
                data2.seek(offset);
                assert (length % 8L == 0L);
                long[] bits2 = new long[(int)length >> 3];
                for (int i = 0; i < bits2.length; ++i) {
                    bits2[i] = data2.readLong();
                }
                instance = new FixedBitSet(bits2, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field2.number);
                return this.getMissingBits(field2.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field2.number);
                return this.getMissingBits(field2.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class SortedSetEntry {
        NumericEntry docToOrdAddress;
        NumericEntry ords;
        BinaryEntry values;

        SortedSetEntry() {
        }
    }

    static class SortedEntry {
        NumericEntry docToOrd;
        BinaryEntry values;

        SortedEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        int count;
        int numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        int count;
        long missingOffset;
        long missingBytes;
        byte byteWidth;
        int packedIntsVersion;

        NumericEntry() {
        }
    }

    static class SortedSetRawValues {
        NumericDocValues docToOrdAddress;
        NumericDocValues ords;
        BinaryDocValues values;

        SortedSetRawValues() {
        }
    }
}

