/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class DirectDocValuesConsumer
extends DocValuesConsumer {
    final IndexOutput data;
    final IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        this.maxDoc = state.segmentInfo.getDocCount();
        boolean success2 = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader(this.data, dataCodec, 0);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader(this.meta, metaCodec, 0);
            return;
        }
        catch (Throwable throwable) {
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.addNumericFieldValues(field2, values2);
    }

    private void addNumericFieldValues(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.meta.writeLong(this.data.getFilePointer());
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        boolean missing = false;
        long count2 = 0L;
        for (Number nv : values2) {
            if (nv != null) {
                long v = nv.longValue();
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
            } else {
                missing = true;
            }
            if (++count2 < 0x7FFFFEFFL) continue;
            throw new IllegalArgumentException("DocValuesField \"" + field2.name + "\" is too large, must be <= " + 0x7FFFFEFF + " values/total ords");
        }
        this.meta.writeInt((int)count2);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values2);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        int byteWidth = minValue >= -128L && maxValue <= 127L ? 1 : (minValue >= -32768L && maxValue <= 32767L ? 2 : (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE ? 4 : 8));
        this.meta.writeByte((byte)byteWidth);
        for (Number nv : values2) {
            long v = nv != null ? nv.longValue() : 0L;
            switch (byteWidth) {
                case 1: {
                    this.data.writeByte((byte)v);
                    break;
                }
                case 2: {
                    this.data.writeShort((short)v);
                    break;
                }
                case 4: {
                    this.data.writeInt((int)v);
                    break;
                }
                case 8: {
                    this.data.writeLong(v);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block6: {
            block5: {
                boolean success2 = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                    }
                    if (!(success2 = true)) break block5;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block6;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)1);
        this.addBinaryFieldValues(field2, values2);
    }

    private void addBinaryFieldValues(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        long startFP = this.data.getFilePointer();
        boolean missing = false;
        long totalBytes = 0L;
        int count2 = 0;
        for (BytesRef v : values2) {
            if (v != null) {
                this.data.writeBytes(v.bytes, v.offset, v.length);
                if ((totalBytes += (long)v.length) > 0x7FFFFEFFL) {
                    throw new IllegalArgumentException("DocValuesField \"" + field2.name + "\" is too large, cannot have more than DirectDocValuesFormat.MAX_TOTAL_BYTES_LENGTH (" + 0x7FFFFEFF + ") bytes");
                }
            } else {
                missing = true;
            }
            ++count2;
        }
        this.meta.writeLong(startFP);
        this.meta.writeInt((int)totalBytes);
        this.meta.writeInt(count2);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values2);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        int addr = 0;
        for (BytesRef v : values2) {
            this.data.writeInt(addr);
            if (v == null) continue;
            addr += v.length;
        }
        this.data.writeInt(addr);
    }

    void writeMissingBitset(Iterable<?> values2) throws IOException {
        long bits2 = 0L;
        int count2 = 0;
        for (Object v : values2) {
            if (count2 == 64) {
                this.data.writeLong(bits2);
                count2 = 0;
                bits2 = 0L;
            }
            if (v != null) {
                bits2 |= 1L << (count2 & 0x3F);
            }
            ++count2;
        }
        if (count2 > 0) {
            this.data.writeLong(bits2);
        }
    }

    @Override
    public void addSortedField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrd) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)2);
        this.addNumericFieldValues(field2, docToOrd);
        this.addBinaryFieldValues(field2, values2);
    }

    @Override
    public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values2, final Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)3);
        this.addNumericFieldValues(field2, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator iter2 = docToOrdCount.iterator();
                return new Iterator<Number>(){
                    long sum;
                    boolean ended;

                    @Override
                    public boolean hasNext() {
                        return iter2.hasNext() || !this.ended;
                    }

                    @Override
                    public Number next() {
                        long toReturn = this.sum;
                        if (iter2.hasNext()) {
                            Number n = (Number)iter2.next();
                            if (n != null) {
                                this.sum += n.longValue();
                            }
                        } else if (!this.ended) {
                            this.ended = true;
                        } else assert (false);
                        return toReturn;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        this.addNumericFieldValues(field2, ords);
        this.addBinaryFieldValues(field2, values2);
    }
}

