/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

public class Lucene46SegmentInfoWriter
extends SegmentInfoWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory dir, SegmentInfo si, FieldInfos fis, IOContext ioContext) throws IOException {
        block5: {
            IndexOutput output2;
            block4: {
                String fileName = IndexFileNames.segmentFileName(si.name, "", "si");
                si.addFile(fileName);
                output2 = dir.createOutput(fileName, ioContext);
                boolean success2 = false;
                try {
                    CodecUtil.writeHeader(output2, "Lucene46SegmentInfo", 0);
                    output2.writeString(si.getVersion());
                    output2.writeInt(si.getDocCount());
                    output2.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
                    output2.writeStringStringMap(si.getDiagnostics());
                    output2.writeStringSet(si.files());
                    success2 = true;
                    if (success2) break block4;
                }
                catch (Throwable throwable) {
                    if (!success2) {
                        IOUtils.closeWhileHandlingException(output2);
                        si.dir.deleteFile(fileName);
                    } else {
                        output2.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(output2);
                si.dir.deleteFile(fileName);
                break block5;
            }
            output2.close();
        }
    }
}

