/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

public class Lucene46SegmentInfoReader
extends SegmentInfoReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, IOContext context) throws IOException {
        SegmentInfo segmentInfo;
        block7: {
            IndexInput input2;
            block6: {
                String fileName = IndexFileNames.segmentFileName(segment, "", "si");
                input2 = dir.openInput(fileName, context);
                boolean success2 = false;
                try {
                    CodecUtil.checkHeader(input2, "Lucene46SegmentInfo", 0, 0);
                    String version = input2.readString();
                    int docCount = input2.readInt();
                    if (docCount < 0) {
                        throw new CorruptIndexException("invalid docCount: " + docCount + " (resource=" + input2 + ")");
                    }
                    boolean isCompoundFile = input2.readByte() == 1;
                    Map<String, String> diagnostics = input2.readStringStringMap();
                    Set<String> files = input2.readStringSet();
                    if (input2.getFilePointer() != input2.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input2.getFilePointer() + " vs size " + input2.length() + " (resource: " + input2 + ")");
                    }
                    SegmentInfo si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics);
                    si.setFiles(files);
                    success2 = true;
                    segmentInfo = si;
                    if (success2) break block6;
                }
                catch (Throwable throwable) {
                    if (!success2) {
                        IOUtils.closeWhileHandlingException(input2);
                    } else {
                        input2.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input2);
                break block7;
            }
            input2.close();
        }
        return segmentInfo;
    }
}

