/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

final class Lucene46FieldInfosWriter
extends FieldInfosWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory directory, String segmentName, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block17: {
            IndexOutput output2;
            block16: {
                String fileName = IndexFileNames.segmentFileName(segmentName, segmentSuffix, "fnm");
                output2 = directory.createOutput(fileName, context);
                boolean success2 = false;
                try {
                    CodecUtil.writeHeader(output2, "Lucene46FieldInfos", 0);
                    output2.writeVInt(infos.size());
                    for (FieldInfo fi : infos) {
                        FieldInfo.IndexOptions indexOptions = fi.getIndexOptions();
                        byte bits2 = 0;
                        if (fi.hasVectors()) {
                            bits2 = (byte)(bits2 | 2);
                        }
                        if (fi.omitsNorms()) {
                            bits2 = (byte)(bits2 | 0x10);
                        }
                        if (fi.hasPayloads()) {
                            bits2 = (byte)(bits2 | 0x20);
                        }
                        if (fi.isIndexed()) {
                            bits2 = (byte)(bits2 | 1);
                            assert (indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                            if (indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                                bits2 = (byte)(bits2 | 0x40);
                            } else if (indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                                bits2 = (byte)(bits2 | 4);
                            } else if (indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                                bits2 = (byte)(bits2 | 0xFFFFFF80);
                            }
                        }
                        output2.writeString(fi.name);
                        output2.writeVInt(fi.number);
                        output2.writeByte(bits2);
                        byte dv = Lucene46FieldInfosWriter.docValuesByte(fi.getDocValuesType());
                        byte nrm = Lucene46FieldInfosWriter.docValuesByte(fi.getNormType());
                        assert ((dv & 0xFFFFFFF0) == 0 && (nrm & 0xFFFFFFF0) == 0);
                        byte val = (byte)(0xFF & (nrm << 4 | dv));
                        output2.writeByte(val);
                        output2.writeLong(fi.getDocValuesGen());
                        output2.writeStringStringMap(fi.attributes());
                    }
                    success2 = true;
                    if (!success2) break block16;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        output2.close();
                    } else {
                        IOUtils.closeWhileHandlingException(output2);
                    }
                    throw throwable;
                }
                output2.close();
                break block17;
            }
            IOUtils.closeWhileHandlingException(output2);
        }
    }

    private static byte docValuesByte(FieldInfo.DocValuesType type) {
        if (type == null) {
            return 0;
        }
        if (type == FieldInfo.DocValuesType.NUMERIC) {
            return 1;
        }
        if (type == FieldInfo.DocValuesType.BINARY) {
            return 2;
        }
        if (type == FieldInfo.DocValuesType.SORTED) {
            return 3;
        }
        if (type == FieldInfo.DocValuesType.SORTED_SET) {
            return 4;
        }
        throw new AssertionError();
    }
}

