/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene45;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

public class Lucene45DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, NumericEntry> ords;
    private final Map<Integer, NumericEntry> ordIndexes;
    private final IndexInput data;
    private final int maxDoc;
    private final int version;
    private final Map<Integer, MonotonicBlockPackedReader> addressInstances;
    private final Map<Integer, MonotonicBlockPackedReader> ordIndexInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Lucene45DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success2;
        block8: {
            IndexInput in;
            block7: {
                this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openInput(metaName, state.context);
                this.maxDoc = state.segmentInfo.getDocCount();
                success2 = false;
                try {
                    this.version = CodecUtil.checkHeader(in, metaCodec, 0, 1);
                    this.numerics = new HashMap<Integer, NumericEntry>();
                    this.ords = new HashMap<Integer, NumericEntry>();
                    this.ordIndexes = new HashMap<Integer, NumericEntry>();
                    this.binaries = new HashMap<Integer, BinaryEntry>();
                    this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                    this.readFields(in, state.fieldInfos);
                    success2 = true;
                    if (!success2) break block7;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        success2 = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 1);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success2 = true;
            if (success2) return;
        }
        catch (Throwable throwable) {
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private void readSortedField(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n);
    }

    private void readSortedSetFieldWithAddresses(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n1 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n1);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n2 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ordIndexes.put(fieldNumber, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(fieldNumber, Lucene45DocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
            } else if (type == 2) {
                this.readSortedField(fieldNumber, meta, infos);
            } else {
                if (type != 3) throw new CorruptIndexException("invalid type: " + type + ", resource=" + meta);
                SortedSetEntry ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(fieldNumber, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldNumber, meta, infos);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    this.readSortedField(fieldNumber, meta, infos);
                }
            }
            fieldNumber = meta.readVInt();
        }
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry2 = new NumericEntry();
        entry2.format = meta.readVInt();
        entry2.missingOffset = meta.readLong();
        entry2.packedIntsVersion = meta.readVInt();
        entry2.offset = meta.readLong();
        entry2.count = meta.readVLong();
        entry2.blockSize = meta.readVInt();
        switch (entry2.format) {
            case 1: {
                entry2.minValue = meta.readLong();
                entry2.gcd = meta.readLong();
                break;
            }
            case 2: {
                if (entry2.count > Integer.MAX_VALUE) {
                    throw new CorruptIndexException("Cannot use TABLE_COMPRESSED with more than MAX_VALUE values, input=" + meta);
                }
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + meta);
                }
                entry2.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry2.table[i] = meta.readLong();
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry2.format + ", input=" + meta);
            }
        }
        return entry2;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry2 = new BinaryEntry();
        entry2.format = meta.readVInt();
        entry2.missingOffset = meta.readLong();
        entry2.minLength = meta.readVInt();
        entry2.maxLength = meta.readVInt();
        entry2.count = meta.readVLong();
        entry2.offset = meta.readLong();
        switch (entry2.format) {
            case 0: {
                break;
            }
            case 2: {
                entry2.addressInterval = meta.readVInt();
                entry2.addressesOffset = meta.readLong();
                entry2.packedIntsVersion = meta.readVInt();
                entry2.blockSize = meta.readVInt();
                break;
            }
            case 1: {
                entry2.addressesOffset = meta.readLong();
                entry2.packedIntsVersion = meta.readVInt();
                entry2.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry2.format + ", input=" + meta);
            }
        }
        return entry2;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry2 = new SortedSetEntry();
        entry2.format = this.version >= 1 ? meta.readVInt() : 0;
        if (entry2.format != 1 && entry2.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry2.format + ", input=" + meta);
        }
        return entry2;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericEntry entry2 = this.numerics.get(field2.number);
        return this.getNumeric(entry2);
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes2 = 0L;
        for (MonotonicBlockPackedReader monotonicBlockPackedReader : this.addressInstances.values()) {
            sizeInBytes2 += 32L + monotonicBlockPackedReader.ramBytesUsed();
        }
        for (MonotonicBlockPackedReader monotonicBlockPackedReader : this.ordIndexInstances.values()) {
            sizeInBytes2 += 32L + monotonicBlockPackedReader.ramBytesUsed();
        }
        return sizeInBytes2;
    }

    LongValues getNumeric(NumericEntry entry2) throws IOException {
        IndexInput data2 = this.data.clone();
        data2.seek(entry2.offset);
        switch (entry2.format) {
            case 0: {
                BlockPackedReader reader = new BlockPackedReader(data2, entry2.packedIntsVersion, entry2.blockSize, entry2.count, true);
                return reader;
            }
            case 1: {
                final long min2 = entry2.minValue;
                final long mult = entry2.gcd;
                final BlockPackedReader quotientReader = new BlockPackedReader(data2, entry2.packedIntsVersion, entry2.blockSize, entry2.count, true);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return min2 + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                final long[] table = entry2.table;
                int bitsRequired = PackedInts.bitsRequired(table.length - 1);
                final PackedInts.Reader ords = PackedInts.getDirectReaderNoHeader(data2, PackedInts.Format.PACKED, entry2.packedIntsVersion, (int)entry2.count, bitsRequired);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return table[(int)ords.get((int)id)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BinaryEntry bytes = this.binaries.get(field2.number);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field2, bytes);
            }
            case 1: {
                return this.getVariableBinary(field2, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field2, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field2, final BinaryEntry bytes) {
        final IndexInput data2 = this.data.clone();
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result2) {
                long address = bytes.offset + id * (long)bytes.maxLength;
                try {
                    data2.seek(address);
                    byte[] buffer = new byte[bytes.maxLength];
                    data2.readBytes(buffer, 0, buffer.length);
                    result2.bytes = buffer;
                    result2.offset = 0;
                    result2.length = buffer.length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getAddressInstance(IndexInput data2, FieldInfo field2, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses;
        Map<Integer, MonotonicBlockPackedReader> map2 = this.addressInstances;
        synchronized (map2) {
            MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field2.number);
            if (addrInstance == null) {
                data2.seek(bytes.addressesOffset);
                addrInstance = new MonotonicBlockPackedReader(data2, bytes.packedIntsVersion, bytes.blockSize, bytes.count, false);
                this.addressInstances.put(field2.number, addrInstance);
            }
            addresses = addrInstance;
        }
        return addresses;
    }

    private BinaryDocValues getVariableBinary(FieldInfo field2, final BinaryEntry bytes) throws IOException {
        final IndexInput data2 = this.data.clone();
        final MonotonicBlockPackedReader addresses = this.getAddressInstance(data2, field2, bytes);
        return new LongBinaryDocValues(){

            @Override
            public void get(long id, BytesRef result2) {
                long startAddress = bytes.offset + (id == 0L ? 0L : addresses.get(id - 1L));
                long endAddress = bytes.offset + addresses.get(id);
                int length = (int)(endAddress - startAddress);
                try {
                    data2.seek(startAddress);
                    byte[] buffer = new byte[length];
                    data2.readBytes(buffer, 0, buffer.length);
                    result2.bytes = buffer;
                    result2.offset = 0;
                    result2.length = length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getIntervalInstance(IndexInput data2, FieldInfo field2, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses;
        long interval = bytes.addressInterval;
        Map<Integer, MonotonicBlockPackedReader> map2 = this.addressInstances;
        synchronized (map2) {
            MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field2.number);
            if (addrInstance == null) {
                data2.seek(bytes.addressesOffset);
                long size2 = bytes.count % interval == 0L ? bytes.count / interval : 1L + bytes.count / interval;
                addrInstance = new MonotonicBlockPackedReader(data2, bytes.packedIntsVersion, bytes.blockSize, size2, false);
                this.addressInstances.put(field2.number, addrInstance);
            }
            addresses = addrInstance;
        }
        return addresses;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field2, BinaryEntry bytes) throws IOException {
        IndexInput data2 = this.data.clone();
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(data2, field2, bytes);
        return new CompressedBinaryDocValues(bytes, addresses, data2);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field2) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)Integer.valueOf((int)field2.number)).count;
        final BinaryDocValues binary = this.getBinary(field2);
        NumericEntry entry2 = this.ords.get(field2.number);
        IndexInput data2 = this.data.clone();
        data2.seek(entry2.offset);
        final BlockPackedReader ordinals = new BlockPackedReader(data2, entry2.packedIntsVersion, entry2.blockSize, entry2.count, true);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                binary.get(ord, result2);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }

            @Override
            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data2, FieldInfo field2, NumericEntry entry2) throws IOException {
        MonotonicBlockPackedReader ordIndex;
        Map<Integer, MonotonicBlockPackedReader> map2 = this.ordIndexInstances;
        synchronized (map2) {
            MonotonicBlockPackedReader ordIndexInstance = this.ordIndexInstances.get(field2.number);
            if (ordIndexInstance == null) {
                data2.seek(entry2.offset);
                ordIndexInstance = new MonotonicBlockPackedReader(data2, entry2.packedIntsVersion, entry2.blockSize, entry2.count, false);
                this.ordIndexInstances.put(field2.number, ordIndexInstance);
            }
            ordIndex = ordIndexInstance;
        }
        return ordIndex;
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field2.number);
        if (ss.format == 1) {
            SortedDocValues values2 = this.getSorted(field2);
            return new SingletonSortedSetDocValues(values2);
        }
        if (ss.format != 0) {
            throw new AssertionError();
        }
        IndexInput data2 = this.data.clone();
        final long valueCount = this.binaries.get((Object)Integer.valueOf((int)field2.number)).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field2);
        final LongValues ordinals = this.getNumeric(this.ords.get(field2.number));
        final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(data2, field2, this.ordIndexes.get(field2.number));
        return new SortedSetDocValues(){
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.offset = docID == 0 ? 0L : ordIndex.get(docID - 1);
                this.endOffset = ordIndex.get(docID);
            }

            @Override
            public void lookupOrd(long ord, BytesRef result2) {
                binary.get(ord, result2);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private Bits getMissingBits(final long offset) throws IOException {
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        final IndexInput in = this.data.clone();
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    in.seek(offset + (long)(index >> 3));
                    return (in.readByte() & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return Lucene45DocValuesProducer.this.maxDoc;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field2.number);
                return this.getMissingBits(be.missingOffset);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field2.number);
                return this.getMissingBits(ne.missingOffset);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final BinaryEntry bytes;
        final long interval;
        final long numValues;
        final long numIndexValues;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final TermsEnum termsEnum;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, IndexInput data2) throws IOException {
            this.bytes = bytes;
            this.interval = bytes.addressInterval;
            this.addresses = addresses;
            this.data = data2;
            this.numValues = bytes.count;
            this.numIndexValues = addresses.size();
            this.termsEnum = this.getTermsEnum(data2);
        }

        @Override
        public void get(long id, BytesRef result2) {
            try {
                this.termsEnum.seekExact(id);
                BytesRef term = this.termsEnum.term();
                result2.bytes = term.bytes;
                result2.offset = term.offset;
                result2.length = term.length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
                if (status == TermsEnum.SeekStatus.END) {
                    return -this.numValues - 1L;
                }
                if (status == TermsEnum.SeekStatus.FOUND) {
                    return this.termsEnum.ord();
                }
                return -this.termsEnum.ord() - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TermsEnum getTermsEnum(final IndexInput input2) throws IOException {
            input2.seek(this.bytes.offset);
            return new TermsEnum(){
                private long currentOrd = -1L;
                private final BytesRef termBuffer;
                private final BytesRef term;
                {
                    this.termBuffer = new BytesRef(CompressedBinaryDocValues.this.bytes.maxLength < 0 ? 0 : CompressedBinaryDocValues.this.bytes.maxLength);
                    this.term = new BytesRef();
                }

                @Override
                public BytesRef next() throws IOException {
                    if (this.doNext() == null) {
                        return null;
                    }
                    this.setTerm();
                    return this.term;
                }

                private BytesRef doNext() throws IOException {
                    if (++this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                        return null;
                    }
                    int start = input2.readVInt();
                    int suffix = input2.readVInt();
                    input2.readBytes(this.termBuffer.bytes, start, suffix);
                    this.termBuffer.length = start + suffix;
                    return this.termBuffer;
                }

                @Override
                public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
                    int cmp;
                    long low = 0L;
                    long high = CompressedBinaryDocValues.this.numIndexValues - 1L;
                    while (low <= high) {
                        long mid = low + high >>> 1;
                        this.doSeek(mid * CompressedBinaryDocValues.this.interval);
                        cmp = this.termBuffer.compareTo(text2);
                        if (cmp < 0) {
                            low = mid + 1L;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1L;
                            continue;
                        }
                        this.setTerm();
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (CompressedBinaryDocValues.this.numIndexValues == 0L) {
                        return TermsEnum.SeekStatus.END;
                    }
                    long block = low - 1L;
                    this.doSeek(block < 0L ? -1L : block * CompressedBinaryDocValues.this.interval);
                    while (this.doNext() != null) {
                        cmp = this.termBuffer.compareTo(text2);
                        if (cmp == 0) {
                            this.setTerm();
                            return TermsEnum.SeekStatus.FOUND;
                        }
                        if (cmp <= 0) continue;
                        this.setTerm();
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }

                @Override
                public void seekExact(long ord) throws IOException {
                    this.doSeek(ord);
                    this.setTerm();
                }

                private void doSeek(long ord) throws IOException {
                    long block = ord / CompressedBinaryDocValues.this.interval;
                    if (ord < this.currentOrd || block != this.currentOrd / CompressedBinaryDocValues.this.interval) {
                        this.currentOrd = ord - ord % CompressedBinaryDocValues.this.interval - 1L;
                        input2.seek(CompressedBinaryDocValues.this.bytes.offset + CompressedBinaryDocValues.this.addresses.get(block));
                    }
                    while (this.currentOrd < ord) {
                        this.doNext();
                    }
                }

                private void setTerm() {
                    this.term.bytes = new byte[this.termBuffer.length];
                    this.term.offset = 0;
                    this.term.copyBytes(this.termBuffer);
                }

                @Override
                public BytesRef term() throws IOException {
                    return this.term;
                }

                @Override
                public long ord() throws IOException {
                    return this.currentOrd;
                }

                @Override
                public Comparator<BytesRef> getComparator() {
                    return BytesRef.getUTF8SortedAsUnicodeComparator();
                }

                @Override
                public int docFreq() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long totalTermFreq() throws IOException {
                    return -1L;
                }

                @Override
                public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final void get(int docID, BytesRef result2) {
            this.get((long)docID, result2);
        }

        abstract void get(long var1, BytesRef var3);
    }

    protected static class SortedSetEntry {
        int format;

        private SortedSetEntry() {
        }
    }

    protected static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressInterval;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    protected static class NumericEntry {
        long missingOffset;
        public long offset;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

