/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene40.Lucene40FieldInfosReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene40DocValuesReader
extends DocValuesProducer {
    private final Directory dir;
    private final SegmentReadState state;
    private final String legacyKey;
    private static final String segmentSuffix = "dv";
    private final Map<Integer, NumericDocValues> numericInstances = new HashMap<Integer, NumericDocValues>();
    private final Map<Integer, BinaryDocValues> binaryInstances = new HashMap<Integer, BinaryDocValues>();
    private final Map<Integer, SortedDocValues> sortedInstances = new HashMap<Integer, SortedDocValues>();

    Lucene40DocValuesReader(SegmentReadState state, String filename, String legacyKey) throws IOException {
        this.state = state;
        this.legacyKey = legacyKey;
        this.dir = new CompoundFileDirectory(state.directory, filename, state.context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericDocValues instance;
        block15: {
            block16: {
                IndexInput input2;
                block14: {
                    instance = this.numericInstances.get(field2.number);
                    if (instance != null) break block15;
                    String fileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                    input2 = this.dir.openInput(fileName, this.state.context);
                    boolean success2 = false;
                    try {
                        switch (Lucene40FieldInfosReader.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                            case VAR_INTS: {
                                instance = this.loadVarIntsField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_8: {
                                instance = this.loadByteField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_16: {
                                instance = this.loadShortField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_32: {
                                instance = this.loadIntField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_64: {
                                instance = this.loadLongField(field2, input2);
                                break;
                            }
                            case FLOAT_32: {
                                instance = this.loadFloatField(field2, input2);
                                break;
                            }
                            case FLOAT_64: {
                                instance = this.loadDoubleField(field2, input2);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        if (input2.getFilePointer() != input2.length()) {
                            throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input2.getFilePointer() + " vs size " + input2.length() + " (resource: " + input2 + ")");
                        }
                        success2 = true;
                        if (!success2) break block14;
                    }
                    catch (Throwable throwable) {
                        if (success2) {
                            IOUtils.close(input2);
                        } else {
                            IOUtils.closeWhileHandlingException(input2);
                        }
                        throw throwable;
                    }
                    IOUtils.close(input2);
                    break block16;
                }
                IOUtils.closeWhileHandlingException(input2);
            }
            this.numericInstances.put(field2.number, instance);
        }
        return instance;
    }

    private NumericDocValues loadVarIntsField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "PackedInts", 0, 0);
        byte header = input2.readByte();
        if (header == 1) {
            int maxDoc = this.state.segmentInfo.getDocCount();
            final long[] values2 = new long[maxDoc];
            for (int i = 0; i < values2.length; ++i) {
                values2[i] = input2.readLong();
            }
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return values2[docID];
                }
            };
        }
        if (header == 0) {
            final long minValue = input2.readLong();
            final long defaultValue = input2.readLong();
            final PackedInts.Reader reader = PackedInts.getReader(input2);
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    long value2 = reader.get(docID);
                    if (value2 == defaultValue) {
                        return 0L;
                    }
                    return minValue + value2;
                }
            };
        }
        throw new CorruptIndexException("invalid VAR_INTS header byte: " + header + " (resource=" + input2 + ")");
    }

    private NumericDocValues loadByteField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 1) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final byte[] values2 = new byte[maxDoc];
        input2.readBytes(values2, 0, values2.length);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadShortField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 2) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final short[] values2 = new short[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readShort();
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadIntField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final int[] values2 = new int[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readInt();
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadLongField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final long[] values2 = new long[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readLong();
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadFloatField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Floats", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final int[] values2 = new int[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readInt();
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadDoubleField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Floats", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final long[] values2 = new long[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readLong();
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field2.number);
        if (instance == null) {
            switch (Lucene40FieldInfosReader.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                case BYTES_FIXED_STRAIGHT: {
                    instance = this.loadBytesFixedStraight(field2);
                    break;
                }
                case BYTES_VAR_STRAIGHT: {
                    instance = this.loadBytesVarStraight(field2);
                    break;
                }
                case BYTES_FIXED_DEREF: {
                    instance = this.loadBytesFixedDeref(field2);
                    break;
                }
                case BYTES_VAR_DEREF: {
                    instance = this.loadBytesVarDeref(field2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.binaryInstances.put(field2.number, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedStraight(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput input2;
            block5: {
                String fileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                input2 = this.dir.openInput(fileName, this.state.context);
                boolean success2 = false;
                try {
                    CodecUtil.checkHeader(input2, "FixedStraightBytes", 0, 0);
                    final int fixedLength = input2.readInt();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(input2, (long)fixedLength * (long)this.state.segmentInfo.getDocCount());
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    if (input2.getFilePointer() != input2.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input2.getFilePointer() + " vs size " + input2.length() + " (resource: " + input2 + ")");
                    }
                    success2 = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public void get(int docID, BytesRef result2) {
                            bytesReader.fillSlice(result2, (long)fixedLength * (long)docID, fixedLength);
                        }
                    };
                    if (!success2) break block5;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(input2);
                    } else {
                        IOUtils.closeWhileHandlingException(input2);
                    }
                    throw throwable;
                }
                IOUtils.close(input2);
                break block6;
            }
            IOUtils.closeWhileHandlingException(input2);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarStraight(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block7: {
            IndexInput index;
            IndexInput data2;
            block6: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data2 = null;
                index = null;
                boolean success2 = false;
                try {
                    data2 = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data2, "VarStraightBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "VarStraightBytesIdx", 0, 0);
                    long totalBytes = index.readVLong();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data2, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    if (data2.getFilePointer() != data2.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + dataName + "\": read " + data2.getFilePointer() + " vs size " + data2.length() + " (resource: " + data2 + ")");
                    }
                    if (index.getFilePointer() != index.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + indexName + "\": read " + index.getFilePointer() + " vs size " + index.length() + " (resource: " + index + ")");
                    }
                    success2 = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public void get(int docID, BytesRef result2) {
                            long startAddress = reader.get(docID);
                            long endAddress = reader.get(docID + 1);
                            bytesReader.fillSlice(result2, startAddress, (int)(endAddress - startAddress));
                        }
                    };
                    if (!success2) break block6;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(data2, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data2, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data2, index);
                break block7;
            }
            IOUtils.closeWhileHandlingException(data2, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedDeref(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block7: {
            IndexInput index;
            IndexInput data2;
            block6: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data2 = null;
                index = null;
                boolean success2 = false;
                try {
                    data2 = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data2, "FixedDerefBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "FixedDerefBytesIdx", 0, 0);
                    final int fixedLength = data2.readInt();
                    int valueCount = index.readInt();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data2, (long)fixedLength * (long)valueCount);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    if (data2.getFilePointer() != data2.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + dataName + "\": read " + data2.getFilePointer() + " vs size " + data2.length() + " (resource: " + data2 + ")");
                    }
                    if (index.getFilePointer() != index.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + indexName + "\": read " + index.getFilePointer() + " vs size " + index.length() + " (resource: " + index + ")");
                    }
                    success2 = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public void get(int docID, BytesRef result2) {
                            long offset = (long)fixedLength * reader.get(docID);
                            bytesReader.fillSlice(result2, offset, fixedLength);
                        }
                    };
                    if (!success2) break block6;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(data2, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data2, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data2, index);
                break block7;
            }
            IOUtils.closeWhileHandlingException(data2, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarDeref(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block7: {
            IndexInput index;
            IndexInput data2;
            block6: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data2 = null;
                index = null;
                boolean success2 = false;
                try {
                    data2 = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data2, "VarDerefBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "VarDerefBytesIdx", 0, 0);
                    long totalBytes = index.readLong();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data2, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    if (data2.getFilePointer() != data2.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + dataName + "\": read " + data2.getFilePointer() + " vs size " + data2.length() + " (resource: " + data2 + ")");
                    }
                    if (index.getFilePointer() != index.length()) {
                        throw new CorruptIndexException("did not read all bytes from file \"" + indexName + "\": read " + index.getFilePointer() + " vs size " + index.length() + " (resource: " + index + ")");
                    }
                    success2 = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public void get(int docID, BytesRef result2) {
                            long startAddress = reader.get(docID);
                            BytesRef lengthBytes = new BytesRef();
                            bytesReader.fillSlice(lengthBytes, startAddress, 1);
                            byte code = lengthBytes.bytes[lengthBytes.offset];
                            if ((code & 0x80) == 0) {
                                bytesReader.fillSlice(result2, startAddress + 1L, code);
                            } else {
                                bytesReader.fillSlice(lengthBytes, startAddress + 1L, 1);
                                int length = (code & 0x7F) << 8 | lengthBytes.bytes[lengthBytes.offset] & 0xFF;
                                bytesReader.fillSlice(result2, startAddress + 2L, length);
                            }
                        }
                    };
                    if (!success2) break block6;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        IOUtils.close(data2, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data2, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data2, index);
                break block7;
            }
            IOUtils.closeWhileHandlingException(data2, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SortedDocValues getSorted(FieldInfo field2) throws IOException {
        SortedDocValues instance;
        block11: {
            block12: {
                IndexInput index;
                IndexInput data2;
                block10: {
                    instance = this.sortedInstances.get(field2.number);
                    if (instance != null) break block11;
                    String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                    String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                    data2 = null;
                    index = null;
                    boolean success2 = false;
                    try {
                        data2 = this.dir.openInput(dataName, this.state.context);
                        index = this.dir.openInput(indexName, this.state.context);
                        switch (Lucene40FieldInfosReader.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                            case BYTES_FIXED_SORTED: {
                                instance = this.loadBytesFixedSorted(field2, data2, index);
                                break;
                            }
                            case BYTES_VAR_SORTED: {
                                instance = this.loadBytesVarSorted(field2, data2, index);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        if (data2.getFilePointer() != data2.length()) {
                            throw new CorruptIndexException("did not read all bytes from file \"" + dataName + "\": read " + data2.getFilePointer() + " vs size " + data2.length() + " (resource: " + data2 + ")");
                        }
                        if (index.getFilePointer() != index.length()) {
                            throw new CorruptIndexException("did not read all bytes from file \"" + indexName + "\": read " + index.getFilePointer() + " vs size " + index.length() + " (resource: " + index + ")");
                        }
                        success2 = true;
                        if (!success2) break block10;
                    }
                    catch (Throwable throwable) {
                        if (success2) {
                            IOUtils.close(data2, index);
                        } else {
                            IOUtils.closeWhileHandlingException(data2, index);
                        }
                        throw throwable;
                    }
                    IOUtils.close(data2, index);
                    break block12;
                }
                IOUtils.closeWhileHandlingException(data2, index);
            }
            this.sortedInstances.put(field2.number, instance);
        }
        return instance;
    }

    private SortedDocValues loadBytesFixedSorted(FieldInfo field2, IndexInput data2, IndexInput index) throws IOException {
        CodecUtil.checkHeader(data2, "FixedSortedBytesDat", 0, 0);
        CodecUtil.checkHeader(index, "FixedSortedBytesIdx", 0, 0);
        final int fixedLength = data2.readInt();
        final int valueCount = index.readInt();
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(data2, (long)fixedLength * (long)valueCount);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        final PackedInts.Reader reader = PackedInts.getReader(index);
        return this.correctBuggyOrds(new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)reader.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                bytesReader.fillSlice(result2, (long)fixedLength * (long)ord, fixedLength);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues loadBytesVarSorted(FieldInfo field2, IndexInput data2, IndexInput index) throws IOException {
        CodecUtil.checkHeader(data2, "VarDerefBytesDat", 0, 0);
        CodecUtil.checkHeader(index, "VarDerefBytesIdx", 0, 0);
        long maxAddress = index.readLong();
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(data2, maxAddress);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        final PackedInts.Reader addressReader = PackedInts.getReader(index);
        final PackedInts.Reader ordsReader = PackedInts.getReader(index);
        final int valueCount = addressReader.size() - 1;
        return this.correctBuggyOrds(new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordsReader.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                long startAddress = addressReader.get(ord);
                long endAddress = addressReader.get(ord + 1);
                bytesReader.fillSlice(result2, startAddress, (int)(endAddress - startAddress));
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues correctBuggyOrds(final SortedDocValues in) {
        int maxDoc = this.state.segmentInfo.getDocCount();
        for (int i = 0; i < maxDoc; ++i) {
            if (in.getOrd(i) != 0) continue;
            return in;
        }
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return in.getOrd(docID) - 1;
            }

            @Override
            public void lookupOrd(int ord, BytesRef result2) {
                in.lookupOrd(ord + 1, result2);
            }

            @Override
            public int getValueCount() {
                return in.getValueCount() - 1;
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        throw new IllegalStateException("Lucene 4.0 does not support SortedSet: how did you pull this off?");
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        return new Bits.MatchAllBits(this.state.segmentInfo.getDocCount());
    }

    @Override
    public void close() throws IOException {
        this.dir.close();
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this);
    }
}

