/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.codecs.FieldInfosReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

@Deprecated
class Lucene3xFieldInfosReader
extends FieldInfosReader {
    static final String FIELD_INFOS_EXTENSION = "fnm";
    static final int FORMAT_START = -2;
    static final int FORMAT_OMIT_POSITIONS = -3;
    static final int FORMAT_MINIMUM = -2;
    static final int FORMAT_CURRENT = -3;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    Lucene3xFieldInfosReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FieldInfos read(Directory directory, String segmentName, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        IndexInput input2;
        block15: {
            String fileName = IndexFileNames.segmentFileName(segmentName, "", FIELD_INFOS_EXTENSION);
            input2 = directory.openInput(fileName, iocontext);
            boolean success2 = false;
            try {
                int format2 = input2.readVInt();
                if (format2 > -2) {
                    throw new IndexFormatTooOldException(input2, format2, -2, -3);
                }
                if (format2 < -3) {
                    throw new IndexFormatTooNewException(input2, format2, -2, -3);
                }
                int size2 = input2.readVInt();
                FieldInfo[] infos = new FieldInfo[size2];
                for (int i = 0; i < size2; ++i) {
                    FieldInfo.IndexOptions indexOptions;
                    boolean storePayloads;
                    String name = input2.readString();
                    int fieldNumber = i;
                    byte bits2 = input2.readByte();
                    boolean isIndexed = (bits2 & 1) != 0;
                    boolean storeTermVector = (bits2 & 2) != 0;
                    boolean omitNorms = (bits2 & 0x10) != 0;
                    boolean bl = storePayloads = (bits2 & 0x20) != 0;
                    if (!isIndexed) {
                        indexOptions = null;
                    } else if ((bits2 & 0x40) != 0) {
                        indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
                    } else if ((bits2 & 0xFFFFFF80) != 0) {
                        if (format2 > -3) throw new CorruptIndexException("Corrupt fieldinfos, OMIT_POSITIONS set but format=" + format2 + " (resource: " + input2 + ")");
                        indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS;
                    } else {
                        indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
                    }
                    if (indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                        storePayloads = false;
                    }
                    infos[i] = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, null, isIndexed && !omitNorms ? FieldInfo.DocValuesType.NUMERIC : null, Collections.<String, String>emptyMap());
                }
                if (input2.getFilePointer() != input2.length()) {
                    throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input2.getFilePointer() + " vs size " + input2.length() + " (resource: " + input2 + ")");
                }
                FieldInfos fieldInfos2 = new FieldInfos(infos);
                success2 = true;
                fieldInfos = fieldInfos2;
                if (!success2) break block15;
            }
            catch (Throwable throwable) {
                if (success2) {
                    input2.close();
                    throw throwable;
                } else {
                    IOUtils.closeWhileHandlingException(input2);
                }
                throw throwable;
            }
            input2.close();
            return fieldInfos;
        }
        IOUtils.closeWhileHandlingException(input2);
        return fieldInfos;
    }
}

