/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.intblock;

import java.io.IOException;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;

public abstract class VariableIntBlockIndexInput
extends IntIndexInput {
    protected final IndexInput in;
    protected final int maxBlockSize;

    protected VariableIntBlockIndexInput(IndexInput in) throws IOException {
        this.in = in;
        this.maxBlockSize = in.readInt();
    }

    @Override
    public IntIndexInput.Reader reader() throws IOException {
        int[] buffer = new int[this.maxBlockSize];
        IndexInput clone2 = this.in.clone();
        return new Reader(clone2, buffer, this.getBlockReader(clone2, buffer));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public IntIndexInput.Index index() {
        return new Index();
    }

    protected abstract BlockReader getBlockReader(IndexInput var1, int[] var2) throws IOException;

    private class Index
    extends IntIndexInput.Index {
        private long fp;
        private int upto;

        private Index() {
        }

        @Override
        public void read(DataInput indexIn, boolean absolute) throws IOException {
            if (absolute) {
                this.upto = indexIn.readVInt();
                this.fp = indexIn.readVLong();
            } else {
                int uptoDelta = indexIn.readVInt();
                if ((uptoDelta & 1) == 1) {
                    this.upto += uptoDelta >>> 1;
                } else {
                    this.upto = uptoDelta >>> 1;
                    this.fp += indexIn.readVLong();
                }
            }
        }

        public String toString() {
            return "VarIntBlock.Index fp=" + this.fp + " upto=" + this.upto + " maxBlock=" + VariableIntBlockIndexInput.this.maxBlockSize;
        }

        @Override
        public void seek(IntIndexInput.Reader other) throws IOException {
            ((Reader)other).seek(this.fp, this.upto);
        }

        @Override
        public void copyFrom(IntIndexInput.Index other) {
            Index idx = (Index)other;
            this.fp = idx.fp;
            this.upto = idx.upto;
        }

        @Override
        public Index clone() {
            Index other = new Index();
            other.fp = this.fp;
            other.upto = this.upto;
            return other;
        }
    }

    private static class Reader
    extends IntIndexInput.Reader {
        private final IndexInput in;
        public final int[] pending;
        int upto;
        private boolean seekPending;
        private long pendingFP;
        private int pendingUpto;
        private long lastBlockFP;
        private int blockSize;
        private final BlockReader blockReader;

        public Reader(IndexInput in, int[] pending, BlockReader blockReader) {
            this.in = in;
            this.pending = pending;
            this.blockReader = blockReader;
        }

        void seek(long fp, int upto) {
            this.pendingFP = fp;
            this.pendingUpto = upto;
            assert (this.pendingUpto >= 0) : "pendingUpto=" + this.pendingUpto;
            this.seekPending = true;
        }

        private final void maybeSeek() throws IOException {
            if (this.seekPending) {
                if (this.pendingFP != this.lastBlockFP) {
                    this.in.seek(this.pendingFP);
                    this.blockReader.seek(this.pendingFP);
                    this.lastBlockFP = this.pendingFP;
                    this.blockSize = this.blockReader.readBlock();
                }
                this.upto = this.pendingUpto;
                while (this.upto >= this.blockSize) {
                    this.upto -= this.blockSize;
                    this.lastBlockFP = this.in.getFilePointer();
                    this.blockSize = this.blockReader.readBlock();
                }
                this.seekPending = false;
            }
        }

        @Override
        public int next() throws IOException {
            this.maybeSeek();
            if (this.upto == this.blockSize) {
                this.lastBlockFP = this.in.getFilePointer();
                this.blockSize = this.blockReader.readBlock();
                this.upto = 0;
            }
            return this.pending[this.upto++];
        }
    }

    public static interface BlockReader {
        public int readBlock() throws IOException;

        public void seek(long var1) throws IOException;
    }
}

