/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.intblock;

import java.io.IOException;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;

public abstract class FixedIntBlockIndexInput
extends IntIndexInput {
    private final IndexInput in;
    protected final int blockSize;

    public FixedIntBlockIndexInput(IndexInput in) throws IOException {
        this.in = in;
        this.blockSize = in.readVInt();
    }

    @Override
    public IntIndexInput.Reader reader() throws IOException {
        int[] buffer = new int[this.blockSize];
        IndexInput clone2 = this.in.clone();
        return new Reader(clone2, buffer, this.getBlockReader(clone2, buffer));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public IntIndexInput.Index index() {
        return new Index();
    }

    protected abstract BlockReader getBlockReader(IndexInput var1, int[] var2) throws IOException;

    private class Index
    extends IntIndexInput.Index {
        private long fp;
        private int upto;

        private Index() {
        }

        @Override
        public void read(DataInput indexIn, boolean absolute) throws IOException {
            if (absolute) {
                this.upto = indexIn.readVInt();
                this.fp = indexIn.readVLong();
            } else {
                int uptoDelta = indexIn.readVInt();
                if ((uptoDelta & 1) == 1) {
                    this.upto += uptoDelta >>> 1;
                } else {
                    this.upto = uptoDelta >>> 1;
                    this.fp += indexIn.readVLong();
                }
            }
            assert (this.upto < FixedIntBlockIndexInput.this.blockSize);
        }

        @Override
        public void seek(IntIndexInput.Reader other) throws IOException {
            ((Reader)other).seek(this.fp, this.upto);
        }

        @Override
        public void copyFrom(IntIndexInput.Index other) {
            Index idx = (Index)other;
            this.fp = idx.fp;
            this.upto = idx.upto;
        }

        @Override
        public Index clone() {
            Index other = new Index();
            other.fp = this.fp;
            other.upto = this.upto;
            return other;
        }

        public String toString() {
            return "fp=" + this.fp + " upto=" + this.upto;
        }
    }

    private static class Reader
    extends IntIndexInput.Reader {
        private final IndexInput in;
        private final BlockReader blockReader;
        private final int blockSize;
        private final int[] pending;
        private int upto;
        private boolean seekPending;
        private long pendingFP;
        private long lastBlockFP = -1L;

        public Reader(IndexInput in, int[] pending, BlockReader blockReader) {
            this.in = in;
            this.pending = pending;
            this.blockSize = pending.length;
            this.blockReader = blockReader;
            this.upto = this.blockSize;
        }

        void seek(long fp, int upto) {
            assert (upto < this.blockSize);
            if (this.seekPending || fp != this.lastBlockFP) {
                this.pendingFP = fp;
                this.seekPending = true;
            }
            this.upto = upto;
        }

        @Override
        public int next() throws IOException {
            if (this.seekPending) {
                this.in.seek(this.pendingFP);
                this.lastBlockFP = this.pendingFP;
                this.blockReader.readBlock();
                this.seekPending = false;
            } else if (this.upto == this.blockSize) {
                this.lastBlockFP = this.in.getFilePointer();
                this.blockReader.readBlock();
                this.upto = 0;
            }
            return this.pending[this.upto++];
        }
    }

    public static interface BlockReader {
        public void readBlock() throws IOException;
    }
}

