/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.diskdv;

import java.io.IOException;
import org.apache.lucene.codecs.lucene45.Lucene45DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class DiskDocValuesProducer
extends Lucene45DocValuesProducer {
    DiskDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        super(state, dataCodec, dataExtension, metaCodec, metaExtension);
    }

    @Override
    protected MonotonicBlockPackedReader getAddressInstance(IndexInput data2, FieldInfo field2, Lucene45DocValuesProducer.BinaryEntry bytes) throws IOException {
        data2.seek(bytes.addressesOffset);
        return new MonotonicBlockPackedReader(data2.clone(), bytes.packedIntsVersion, bytes.blockSize, bytes.count, true);
    }

    @Override
    protected MonotonicBlockPackedReader getIntervalInstance(IndexInput data2, FieldInfo field2, Lucene45DocValuesProducer.BinaryEntry bytes) throws IOException {
        throw new AssertionError();
    }

    @Override
    protected MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data2, FieldInfo field2, Lucene45DocValuesProducer.NumericEntry entry2) throws IOException {
        data2.seek(entry2.offset);
        return new MonotonicBlockPackedReader(data2.clone(), entry2.packedIntsVersion, entry2.blockSize, entry2.count, true);
    }
}

