/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.diskdv;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.diskdv.DiskDocValuesProducer;
import org.apache.lucene.codecs.lucene45.Lucene45DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;

public final class DiskDocValuesFormat
extends DocValuesFormat {
    public static final String DATA_CODEC = "DiskDocValuesData";
    public static final String DATA_EXTENSION = "dvdd";
    public static final String META_CODEC = "DiskDocValuesMetadata";
    public static final String META_EXTENSION = "dvdm";

    public DiskDocValuesFormat() {
        super("Disk");
    }

    @Override
    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new Lucene45DocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION){

            @Override
            protected void addTermsDict(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
                this.addBinaryField(field2, values2);
            }
        };
    }

    @Override
    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new DiskDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }
}

