/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bloom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.bloom.BloomFilterFactory;
import org.apache.lucene.codecs.bloom.DefaultBloomFilterFactory;
import org.apache.lucene.codecs.bloom.FuzzySet;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class BloomFilteringPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "BloomFilter";
    public static final int BLOOM_CODEC_VERSION = 1;
    static final String BLOOM_EXTENSION = "blm";
    BloomFilterFactory bloomFilterFactory = new DefaultBloomFilterFactory();
    private PostingsFormat delegatePostingsFormat;

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilterFactory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat) {
        this(delegatePostingsFormat, new DefaultBloomFilterFactory());
    }

    public BloomFilteringPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new BloomFilteredFieldsConsumer(this.delegatePostingsFormat.fieldsConsumer(state), state, this.delegatePostingsFormat);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    class WrappedTermsConsumer
    extends TermsConsumer {
        private TermsConsumer delegateTermsConsumer;
        private FuzzySet bloomFilter;

        public WrappedTermsConsumer(TermsConsumer termsConsumer, FuzzySet bloomFilter) {
            this.delegateTermsConsumer = termsConsumer;
            this.bloomFilter = bloomFilter;
        }

        @Override
        public PostingsConsumer startTerm(BytesRef text2) throws IOException {
            return this.delegateTermsConsumer.startTerm(text2);
        }

        @Override
        public void finishTerm(BytesRef text2, TermStats stats) throws IOException {
            if (stats.docFreq > 0) {
                this.bloomFilter.addValue(text2);
            }
            this.delegateTermsConsumer.finishTerm(text2, stats);
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            this.delegateTermsConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        @Override
        public Comparator<BytesRef> getComparator() throws IOException {
            return this.delegateTermsConsumer.getComparator();
        }
    }

    class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, FuzzySet> bloomFilters = new HashMap<FieldInfo, FuzzySet>();
        private SegmentWriteState state;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state, PostingsFormat delegatePostingsFormat) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        @Override
        public TermsConsumer addField(FieldInfo field2) throws IOException {
            FuzzySet bloomFilter = BloomFilteringPostingsFormat.this.bloomFilterFactory.getSetForField(this.state, field2);
            if (bloomFilter != null) {
                assert (!this.bloomFilters.containsKey(field2));
                this.bloomFilters.put(field2, bloomFilter);
                return new WrappedTermsConsumer(this.delegateFieldsConsumer.addField(field2), bloomFilter);
            }
            return this.delegateFieldsConsumer.addField(field2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, FuzzySet>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, FuzzySet>>();
            for (Map.Entry<FieldInfo, FuzzySet> entry2 : this.bloomFilters.entrySet()) {
                FuzzySet bloomFilter = entry2.getValue();
                if (BloomFilteringPostingsFormat.this.bloomFilterFactory.isSaturated(bloomFilter, entry2.getKey())) continue;
                nonSaturatedBlooms.add(entry2);
            }
            String bloomFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            IndexOutput bloomOutput = null;
            try {
                bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);
                CodecUtil.writeHeader(bloomOutput, BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, 1);
                bloomOutput.writeString(BloomFilteringPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry2 : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry2.getKey();
                    FuzzySet bloomFilter = (FuzzySet)entry2.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(bloomOutput);
                throw throwable;
            }
            IOUtils.close(bloomOutput);
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, FuzzySet bloomFilter, FieldInfo fieldInfo) throws IOException {
            FuzzySet rightSizedSet = BloomFilteringPostingsFormat.this.bloomFilterFactory.downsize(fieldInfo, bloomFilter);
            if (rightSizedSet == null) {
                rightSizedSet = bloomFilter;
            }
            rightSizedSet.serialize(bloomOutput);
        }
    }

    public class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, FuzzySet> bloomsByFieldName = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            IndexInput bloomIn = null;
            boolean success2 = false;
            try {
                bloomIn = state.directory.openInput(bloomFileName, state.context);
                CodecUtil.checkHeader(bloomIn, BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, 1, 1);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName(bloomIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numBlooms = bloomIn.readInt();
                for (int i = 0; i < numBlooms; ++i) {
                    int fieldNum = bloomIn.readInt();
                    FuzzySet bloom = FuzzySet.deserialize(bloomIn);
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                    this.bloomsByFieldName.put(fieldInfo.name, bloom);
                }
                IOUtils.close(bloomIn);
                return;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(bloomIn, this.delegateFieldsProducer);
                throw throwable;
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        @Override
        public void close() throws IOException {
            this.delegateFieldsProducer.close();
        }

        @Override
        public Terms terms(String field2) throws IOException {
            FuzzySet filter2 = this.bloomsByFieldName.get(field2);
            if (filter2 == null) {
                return this.delegateFieldsProducer.terms(field2);
            }
            Terms result2 = this.delegateFieldsProducer.terms(field2);
            if (result2 == null) {
                return null;
            }
            return new BloomFilteredTerms(result2, filter2);
        }

        @Override
        public int size() {
            return this.delegateFieldsProducer.size();
        }

        @Override
        public long getUniqueTermCount() throws IOException {
            return this.delegateFieldsProducer.getUniqueTermCount();
        }

        @Override
        public long ramBytesUsed() {
            long sizeInBytes2 = this.delegateFieldsProducer != null ? this.delegateFieldsProducer.ramBytesUsed() : 0L;
            for (Map.Entry<String, FuzzySet> entry2 : this.bloomsByFieldName.entrySet()) {
                sizeInBytes2 += (long)(entry2.getKey().length() * 2);
                sizeInBytes2 += entry2.getValue().ramBytesUsed();
            }
            return sizeInBytes2;
        }

        final class BloomFilteredTermsEnum
        extends TermsEnum {
            private Terms delegateTerms;
            private TermsEnum delegateTermsEnum;
            private TermsEnum reuseDelegate;
            private final FuzzySet filter;

            public BloomFilteredTermsEnum(Terms delegateTerms, TermsEnum reuseDelegate, FuzzySet filter2) throws IOException {
                this.delegateTerms = delegateTerms;
                this.reuseDelegate = reuseDelegate;
                this.filter = filter2;
            }

            void reset(Terms delegateTerms, TermsEnum reuseDelegate) throws IOException {
                this.delegateTerms = delegateTerms;
                this.reuseDelegate = reuseDelegate;
                this.delegateTermsEnum = null;
            }

            private final TermsEnum delegate() throws IOException {
                if (this.delegateTermsEnum == null) {
                    this.delegateTermsEnum = this.delegateTerms.iterator(this.reuseDelegate);
                }
                return this.delegateTermsEnum;
            }

            @Override
            public final BytesRef next() throws IOException {
                return this.delegate().next();
            }

            @Override
            public final Comparator<BytesRef> getComparator() {
                return this.delegateTerms.getComparator();
            }

            @Override
            public final boolean seekExact(BytesRef text2) throws IOException {
                if (this.filter.contains(text2) == FuzzySet.ContainsResult.NO) {
                    return false;
                }
                return this.delegate().seekExact(text2);
            }

            @Override
            public final TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
                return this.delegate().seekCeil(text2);
            }

            @Override
            public final void seekExact(long ord) throws IOException {
                this.delegate().seekExact(ord);
            }

            @Override
            public final BytesRef term() throws IOException {
                return this.delegate().term();
            }

            @Override
            public final long ord() throws IOException {
                return this.delegate().ord();
            }

            @Override
            public final int docFreq() throws IOException {
                return this.delegate().docFreq();
            }

            @Override
            public final long totalTermFreq() throws IOException {
                return this.delegate().totalTermFreq();
            }

            @Override
            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                return this.delegate().docsAndPositions(liveDocs, reuse, flags);
            }

            @Override
            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                return this.delegate().docs(liveDocs, reuse, flags);
            }
        }

        class BloomFilteredTerms
        extends Terms {
            private Terms delegateTerms;
            private FuzzySet filter;

            public BloomFilteredTerms(Terms terms, FuzzySet filter2) {
                this.delegateTerms = terms;
                this.filter = filter2;
            }

            @Override
            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.delegateTerms.intersect(compiled, startTerm);
            }

            @Override
            public TermsEnum iterator(TermsEnum reuse) throws IOException {
                BloomFilteredTermsEnum bfte;
                if (reuse != null && reuse instanceof BloomFilteredTermsEnum && (bfte = (BloomFilteredTermsEnum)reuse).filter == this.filter) {
                    bfte.reset(this.delegateTerms, bfte.delegateTermsEnum);
                    return bfte;
                }
                return new BloomFilteredTermsEnum(this.delegateTerms, reuse, this.filter);
            }

            @Override
            public Comparator<BytesRef> getComparator() {
                return this.delegateTerms.getComparator();
            }

            @Override
            public long size() throws IOException {
                return this.delegateTerms.size();
            }

            @Override
            public long getSumTotalTermFreq() throws IOException {
                return this.delegateTerms.getSumTotalTermFreq();
            }

            @Override
            public long getSumDocFreq() throws IOException {
                return this.delegateTerms.getSumDocFreq();
            }

            @Override
            public int getDocCount() throws IOException {
                return this.delegateTerms.getDocCount();
            }

            @Override
            public boolean hasFreqs() {
                return this.delegateTerms.hasFreqs();
            }

            @Override
            public boolean hasOffsets() {
                return this.delegateTerms.hasOffsets();
            }

            @Override
            public boolean hasPositions() {
                return this.delegateTerms.hasPositions();
            }

            @Override
            public boolean hasPayloads() {
                return this.delegateTerms.hasPayloads();
            }
        }
    }
}

