/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockTermsWriter
extends FieldsConsumer {
    static final String CODEC_NAME = "BLOCK_TERMS_DICT";
    public static final int VERSION_START = 0;
    public static final int VERSION_APPEND_ONLY = 1;
    public static final int VERSION_CURRENT = 1;
    static final String TERMS_EXTENSION = "tib";
    protected final IndexOutput out;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    FieldInfo currentField;
    private final TermsIndexWriterBase termsIndexWriter;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTermsWriter(TermsIndexWriterBase termsIndexWriter, SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, TERMS_EXTENSION);
        this.termsIndexWriter = termsIndexWriter;
        this.out = state.directory.createOutput(termsFileName, state.context);
        boolean success2 = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.writeHeader(this.out);
            this.currentField = null;
            this.postingsWriter = postingsWriter;
            postingsWriter.start(this.out);
            return;
        }
        catch (Throwable throwable) {
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this.out);
            throw throwable;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader(out, CODEC_NAME, 1);
    }

    @Override
    public TermsConsumer addField(FieldInfo field2) throws IOException {
        assert (this.currentField == null || this.currentField.name.compareTo(field2.name) < 0);
        this.currentField = field2;
        TermsIndexWriterBase.FieldWriter fieldIndexWriter = this.termsIndexWriter.addField(field2, this.out.getFilePointer());
        return new TermsWriter(fieldIndexWriter, field2, this.postingsWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            long dirStart = this.out.getFilePointer();
            this.out.writeVInt(this.fields.size());
            for (FieldMetaData field2 : this.fields) {
                this.out.writeVInt(field2.fieldInfo.number);
                this.out.writeVLong(field2.numTerms);
                this.out.writeVLong(field2.termsStartPointer);
                if (field2.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.out.writeVLong(field2.sumTotalTermFreq);
                }
                this.out.writeVLong(field2.sumDocFreq);
                this.out.writeVInt(field2.docCount);
            }
            this.writeTrailer(dirStart);
        }
        catch (Throwable throwable) {
            IOUtils.close(this.out, this.postingsWriter, this.termsIndexWriter);
            throw throwable;
        }
        IOUtils.close(this.out, this.postingsWriter, this.termsIndexWriter);
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    class TermsWriter
    extends TermsConsumer {
        private final FieldInfo fieldInfo;
        private final PostingsWriterBase postingsWriter;
        private final long termsStartPointer;
        private long numTerms;
        private final TermsIndexWriterBase.FieldWriter fieldIndexWriter;
        long sumTotalTermFreq;
        long sumDocFreq;
        int docCount;
        private TermEntry[] pendingTerms;
        private int pendingCount;
        private final BytesRef lastPrevTerm = new BytesRef();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();

        TermsWriter(TermsIndexWriterBase.FieldWriter fieldIndexWriter, FieldInfo fieldInfo, PostingsWriterBase postingsWriter) {
            this.fieldInfo = fieldInfo;
            this.fieldIndexWriter = fieldIndexWriter;
            this.pendingTerms = new TermEntry[32];
            for (int i = 0; i < this.pendingTerms.length; ++i) {
                this.pendingTerms[i] = new TermEntry();
            }
            this.termsStartPointer = BlockTermsWriter.this.out.getFilePointer();
            postingsWriter.setField(fieldInfo);
            this.postingsWriter = postingsWriter;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public PostingsConsumer startTerm(BytesRef text2) throws IOException {
            this.postingsWriter.startTerm();
            return this.postingsWriter;
        }

        @Override
        public void finishTerm(BytesRef text2, TermStats stats) throws IOException {
            assert (stats.docFreq > 0);
            boolean isIndexTerm = this.fieldIndexWriter.checkIndexTerm(text2, stats);
            if (isIndexTerm) {
                if (this.pendingCount > 0) {
                    this.flushBlock();
                }
                this.fieldIndexWriter.add(text2, stats, BlockTermsWriter.this.out.getFilePointer());
            }
            if (this.pendingTerms.length == this.pendingCount) {
                TermEntry[] newArray = new TermEntry[ArrayUtil.oversize(this.pendingCount + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.pendingTerms, 0, newArray, 0, this.pendingCount);
                for (int i = this.pendingCount; i < newArray.length; ++i) {
                    newArray[i] = new TermEntry();
                }
                this.pendingTerms = newArray;
            }
            TermEntry te = this.pendingTerms[this.pendingCount];
            te.term.copyBytes(text2);
            te.stats = stats;
            ++this.pendingCount;
            this.postingsWriter.finishTerm(stats);
            ++this.numTerms;
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.pendingCount > 0) {
                this.flushBlock();
            }
            BlockTermsWriter.this.out.writeVInt(0);
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.fieldIndexWriter.finish(BlockTermsWriter.this.out.getFilePointer());
            if (this.numTerms > 0L) {
                BlockTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, this.termsStartPointer, sumTotalTermFreq, sumDocFreq, docCount));
            }
        }

        private int sharedPrefix(BytesRef term1, BytesRef term2) {
            assert (term1.offset == 0);
            assert (term2.offset == 0);
            int pos1 = 0;
            int pos1End = pos1 + Math.min(term1.length, term2.length);
            int pos2 = 0;
            while (pos1 < pos1End) {
                if (term1.bytes[pos1] != term2.bytes[pos2]) {
                    return pos1;
                }
                ++pos1;
                ++pos2;
            }
            return pos1;
        }

        private void flushBlock() throws IOException {
            int termCount;
            int commonPrefix = this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[0].term);
            for (termCount = 1; termCount < this.pendingCount; ++termCount) {
                commonPrefix = Math.min(commonPrefix, this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[termCount].term));
            }
            BlockTermsWriter.this.out.writeVInt(this.pendingCount);
            BlockTermsWriter.this.out.writeVInt(commonPrefix);
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                int suffix = this.pendingTerms[termCount].term.length - commonPrefix;
                this.bytesWriter.writeVInt(suffix);
                this.bytesWriter.writeBytes(this.pendingTerms[termCount].term.bytes, commonPrefix, suffix);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo(BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                TermStats stats = this.pendingTerms[termCount].stats;
                assert (stats != null);
                this.bytesWriter.writeVInt(stats.docFreq);
                if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) continue;
                this.bytesWriter.writeVLong(stats.totalTermFreq - (long)stats.docFreq);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo(BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            this.postingsWriter.flushTermsBlock(this.pendingCount, this.pendingCount);
            this.lastPrevTerm.copyBytes(this.pendingTerms[this.pendingCount - 1].term);
            this.pendingCount = 0;
        }
    }

    private static class TermEntry {
        public final BytesRef term = new BytesRef();
        public TermStats stats;

        private TermEntry() {
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long termsStartPointer;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long termsStartPointer, long sumTotalTermFreq, long sumDocFreq, int docCount) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            this.termsStartPointer = termsStartPointer;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
        }
    }
}

