/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;

public class TypeAsPayloadTokenFilter
extends TokenFilter {
    private final PayloadAttribute payloadAtt = this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public TypeAsPayloadTokenFilter(TokenStream input2) {
        super(input2);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String type = this.typeAtt.type();
            if (type != null && !type.equals("")) {
                this.payloadAtt.setPayload(new BytesRef(type.getBytes("UTF-8")));
            }
            return true;
        }
        return false;
    }
}

