/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public class TokenOffsetPayloadTokenFilter
extends TokenFilter {
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PayloadAttribute payAtt = this.addAttribute(PayloadAttribute.class);

    public TokenOffsetPayloadTokenFilter(TokenStream input2) {
        super(input2);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            byte[] data2 = new byte[8];
            PayloadHelper.encodeInt(this.offsetAtt.startOffset(), data2, 0);
            PayloadHelper.encodeInt(this.offsetAtt.endOffset(), data2, 4);
            BytesRef payload = new BytesRef(data2);
            this.payAtt.setPayload(payload);
            return true;
        }
        return false;
    }
}

