/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

public class PayloadHelper {
    public static byte[] encodeFloat(float payload) {
        return PayloadHelper.encodeFloat(payload, new byte[4], 0);
    }

    public static byte[] encodeFloat(float payload, byte[] data2, int offset) {
        return PayloadHelper.encodeInt(Float.floatToIntBits(payload), data2, offset);
    }

    public static byte[] encodeInt(int payload) {
        return PayloadHelper.encodeInt(payload, new byte[4], 0);
    }

    public static byte[] encodeInt(int payload, byte[] data2, int offset) {
        data2[offset] = (byte)(payload >> 24);
        data2[offset + 1] = (byte)(payload >> 16);
        data2[offset + 2] = (byte)(payload >> 8);
        data2[offset + 3] = (byte)payload;
        return data2;
    }

    public static float decodeFloat(byte[] bytes) {
        return PayloadHelper.decodeFloat(bytes, 0);
    }

    public static final float decodeFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(PayloadHelper.decodeInt(bytes, offset));
    }

    public static final int decodeInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }
}

