/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.no.NorwegianMinimalStemmer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class NorwegianMinimalStemFilter
extends TokenFilter {
    private final NorwegianMinimalStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public NorwegianMinimalStemFilter(TokenStream input2) {
        this(input2, 1);
    }

    public NorwegianMinimalStemFilter(TokenStream input2, int flags) {
        super(input2);
        this.stemmer = new NorwegianMinimalStemmer(flags);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

