/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArrayMap;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.DutchStemmer;

public final class DutchAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final CharArraySet stoptable;
    private CharArraySet excltable = CharArraySet.EMPTY_SET;
    private final StemmerOverrideFilter.StemmerOverrideMap stemdict;
    private final CharArrayMap<String> origStemdict;
    private final Version matchVersion;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords, CharArraySet stemExclusionTable) {
        this(matchVersion, stopwords, stemExclusionTable, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, CharArraySet stopwords, CharArraySet stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionTable));
        if (stemOverrideDict.isEmpty() || !matchVersion.onOrAfter(Version.LUCENE_31)) {
            this.stemdict = null;
            this.origStemdict = CharArrayMap.unmodifiableMap(CharArrayMap.copy(matchVersion, stemOverrideDict));
        } else {
            this.origStemdict = null;
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
            CharArrayMap.EntryIterator iter2 = stemOverrideDict.entrySet().iterator();
            CharsRef spare = new CharsRef();
            while (iter2.hasNext()) {
                char[] nextKey = iter2.nextKey();
                spare.copyChars(nextKey, 0, nextKey.length);
                builder.add(spare, (CharSequence)iter2.currentValue());
            }
            try {
                this.stemdict = builder.build();
            }
            catch (IOException ex) {
                throw new RuntimeException("can not build stem dict", ex);
            }
        }
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
            TokenFilter result2 = new StandardFilter(this.matchVersion, source);
            result2 = new LowerCaseFilter(this.matchVersion, result2);
            result2 = new StopFilter(this.matchVersion, result2, this.stoptable);
            if (!this.excltable.isEmpty()) {
                result2 = new SetKeywordMarkerFilter(result2, this.excltable);
            }
            if (this.stemdict != null) {
                result2 = new StemmerOverrideFilter(result2, this.stemdict);
            }
            result2 = new SnowballFilter((TokenStream)result2, new DutchStemmer());
            return new Analyzer.TokenStreamComponents(source, result2);
        }
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
        TokenFilter result3 = new StandardFilter(this.matchVersion, source);
        result3 = new StopFilter(this.matchVersion, result3, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result3 = new SetKeywordMarkerFilter(result3, this.excltable);
        }
        result3 = new DutchStemFilter(result3, this.origStemdict);
        return new Analyzer.TokenStreamComponents(source, result3);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, DutchAnalyzer.DEFAULT_STOPWORD_FILE, IOUtils.CHARSET_UTF_8), Version.LUCENE_CURRENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
            DEFAULT_STEM_DICT = new CharArrayMap(Version.LUCENE_CURRENT, 4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

