/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;

public final class StemmerOverrideFilter
extends TokenFilter {
    private final StemmerOverrideMap stemmerOverrideMap;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final FST.BytesReader fstReader;
    private final FST.Arc<BytesRef> scratchArc = new FST.Arc();
    private final CharsRef spare = new CharsRef();

    public StemmerOverrideFilter(TokenStream input2, StemmerOverrideMap stemmerOverrideMap) {
        super(input2);
        this.stemmerOverrideMap = stemmerOverrideMap;
        this.fstReader = stemmerOverrideMap.getBytesReader();
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            BytesRef stem;
            if (this.fstReader == null) {
                return true;
            }
            if (!this.keywordAtt.isKeyword() && (stem = this.stemmerOverrideMap.get(this.termAtt.buffer(), this.termAtt.length(), this.scratchArc, this.fstReader)) != null) {
                this.spare.chars = this.termAtt.buffer();
                char[] buffer = this.spare.chars;
                UnicodeUtil.UTF8toUTF16(stem.bytes, stem.offset, stem.length, this.spare);
                if (this.spare.chars != buffer) {
                    this.termAtt.copyBuffer(this.spare.chars, this.spare.offset, this.spare.length);
                }
                this.termAtt.setLength(this.spare.length);
                this.keywordAtt.setKeyword(true);
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private final BytesRefHash hash = new BytesRefHash();
        private final BytesRef spare = new BytesRef();
        private final ArrayList<CharSequence> outputValues = new ArrayList();
        private final boolean ignoreCase;
        private final CharsRef charsSpare = new CharsRef();

        public Builder() {
            this(false);
        }

        public Builder(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public boolean add(CharSequence input2, CharSequence output2) {
            int length = input2.length();
            if (this.ignoreCase) {
                this.charsSpare.grow(length);
                char[] buffer = this.charsSpare.chars;
                for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(Character.codePointAt(input2, i)), buffer, i)) {
                }
                UnicodeUtil.UTF16toUTF8(buffer, 0, length, this.spare);
            } else {
                UnicodeUtil.UTF16toUTF8(input2, 0, length, this.spare);
            }
            if (this.hash.add(this.spare) >= 0) {
                this.outputValues.add(output2);
                return true;
            }
            return false;
        }

        public StemmerOverrideMap build() throws IOException {
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            org.apache.lucene.util.fst.Builder<BytesRef> builder = new org.apache.lucene.util.fst.Builder<BytesRef>(FST.INPUT_TYPE.BYTE4, outputs);
            int[] sort2 = this.hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
            IntsRef intsSpare = new IntsRef();
            int size2 = this.hash.size();
            for (int i = 0; i < size2; ++i) {
                int id = sort2[i];
                BytesRef bytesRef = this.hash.get(id, this.spare);
                UnicodeUtil.UTF8toUTF32(bytesRef, intsSpare);
                builder.add(intsSpare, new BytesRef(this.outputValues.get(id)));
            }
            return new StemmerOverrideMap(builder.finish(), this.ignoreCase);
        }
    }

    public static final class StemmerOverrideMap {
        private final FST<BytesRef> fst;
        private final boolean ignoreCase;

        public StemmerOverrideMap(FST<BytesRef> fst, boolean ignoreCase) {
            this.fst = fst;
            this.ignoreCase = ignoreCase;
        }

        public FST.BytesReader getBytesReader() {
            if (this.fst == null) {
                return null;
            }
            return this.fst.getBytesReader();
        }

        public BytesRef get(char[] buffer, int bufferLen, FST.Arc<BytesRef> scratchArc, FST.BytesReader fstReader) throws IOException {
            int codePoint;
            BytesRef pendingOutput = (BytesRef)this.fst.outputs.getNoOutput();
            BytesRef matchOutput = null;
            this.fst.getFirstArc(scratchArc);
            for (int bufUpto = 0; bufUpto < bufferLen; bufUpto += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(buffer, bufUpto, bufferLen);
                if (this.fst.findTargetArc(this.ignoreCase ? Character.toLowerCase(codePoint) : codePoint, scratchArc, scratchArc, fstReader) == null) {
                    return null;
                }
                pendingOutput = this.fst.outputs.add(pendingOutput, (BytesRef)scratchArc.output);
            }
            if (scratchArc.isFinal()) {
                matchOutput = this.fst.outputs.add(pendingOutput, (BytesRef)scratchArc.nextFinalOutput);
            }
            return matchOutput;
        }
    }
}

