/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public class NormalizeCharMap {
    final FST<CharsRef> map;
    final Map<Character, FST.Arc<CharsRef>> cachedRootArcs = new HashMap<Character, FST.Arc<CharsRef>>();

    private NormalizeCharMap(FST<CharsRef> map2) {
        this.map = map2;
        if (map2 != null) {
            try {
                FST.Arc scratchArc = new FST.Arc();
                FST.BytesReader fstReader = map2.getBytesReader();
                map2.getFirstArc(scratchArc);
                if (FST.targetHasArcs(scratchArc)) {
                    map2.readFirstRealTargetArc(scratchArc.target, scratchArc, fstReader);
                    while (true) {
                        assert (scratchArc.label != -1);
                        this.cachedRootArcs.put(Character.valueOf((char)scratchArc.label), new FST.Arc().copyFrom(scratchArc));
                        if (!scratchArc.isLast()) {
                            map2.readNextRealArc(scratchArc, fstReader);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class Builder {
        private final Map<String, String> pendingPairs = new TreeMap<String, String>();

        public void add(String match, String replacement) {
            if (match.length() == 0) {
                throw new IllegalArgumentException("cannot match the empty string");
            }
            if (this.pendingPairs.containsKey(match)) {
                throw new IllegalArgumentException("match \"" + match + "\" was already added");
            }
            this.pendingPairs.put(match, replacement);
        }

        public NormalizeCharMap build() {
            FST<CharsRef> map2;
            try {
                CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
                org.apache.lucene.util.fst.Builder<CharsRef> builder = new org.apache.lucene.util.fst.Builder<CharsRef>(FST.INPUT_TYPE.BYTE2, outputs);
                IntsRef scratch = new IntsRef();
                for (Map.Entry<String, String> ent : this.pendingPairs.entrySet()) {
                    builder.add(Util.toUTF16(ent.getKey(), scratch), new CharsRef(ent.getValue()));
                }
                map2 = builder.finish();
                this.pendingPairs.clear();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return new NormalizeCharMap(map2);
        }
    }
}

