/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.ReusableStringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer
implements Closeable {
    private final ReuseStrategy reuseStrategy;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    public static final ReuseStrategy GLOBAL_REUSE_STRATEGY = new GlobalReuseStrategy();
    public static final ReuseStrategy PER_FIELD_REUSE_STRATEGY = new PerFieldReuseStrategy();

    public Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    public Analyzer(ReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    protected abstract TokenStreamComponents createComponents(String var1, Reader var2);

    public final TokenStream tokenStream(String fieldName, Reader reader) throws IOException {
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        Reader r = this.initReader(fieldName, reader);
        if (components == null) {
            components = this.createComponents(fieldName, r);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        } else {
            components.setReader(r);
        }
        return components.getTokenStream();
    }

    public final TokenStream tokenStream(String fieldName, String text2) throws IOException {
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        ReusableStringReader strReader = components == null || components.reusableStringReader == null ? new ReusableStringReader() : components.reusableStringReader;
        strReader.setValue(text2);
        Reader r = this.initReader(fieldName, strReader);
        if (components == null) {
            components = this.createComponents(fieldName, r);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        } else {
            components.setReader(r);
        }
        components.reusableStringReader = strReader;
        return components.getTokenStream();
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return reader;
    }

    public int getPositionIncrementGap(String fieldName) {
        return 0;
    }

    public int getOffsetGap(String fieldName) {
        return 1;
    }

    public final ReuseStrategy getReuseStrategy() {
        return this.reuseStrategy;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    @Deprecated
    public static class PerFieldReuseStrategy
    extends ReuseStrategy {
        @Deprecated
        public PerFieldReuseStrategy() {
        }

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            Map componentsPerField = (Map)this.getStoredValue(analyzer);
            return componentsPerField != null ? (TokenStreamComponents)componentsPerField.get(fieldName) : null;
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            HashMap<String, TokenStreamComponents> componentsPerField = (HashMap<String, TokenStreamComponents>)this.getStoredValue(analyzer);
            if (componentsPerField == null) {
                componentsPerField = new HashMap<String, TokenStreamComponents>();
                this.setStoredValue(analyzer, componentsPerField);
            }
            componentsPerField.put(fieldName, components);
        }
    }

    @Deprecated
    public static final class GlobalReuseStrategy
    extends ReuseStrategy {
        @Deprecated
        public GlobalReuseStrategy() {
        }

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            return (TokenStreamComponents)this.getStoredValue(analyzer);
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            this.setStoredValue(analyzer, components);
        }
    }

    public static abstract class ReuseStrategy {
        public abstract TokenStreamComponents getReusableComponents(Analyzer var1, String var2);

        public abstract void setReusableComponents(Analyzer var1, String var2, TokenStreamComponents var3);

        protected final Object getStoredValue(Analyzer analyzer) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            return analyzer.storedValue.get();
        }

        protected final void setStoredValue(Analyzer analyzer, Object storedValue) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            analyzer.storedValue.set(storedValue);
        }
    }

    public static class TokenStreamComponents {
        protected final Tokenizer source;
        protected final TokenStream sink;
        transient ReusableStringReader reusableStringReader;

        public TokenStreamComponents(Tokenizer source, TokenStream result2) {
            this.source = source;
            this.sink = result2;
        }

        public TokenStreamComponents(Tokenizer source) {
            this.source = source;
            this.sink = source;
        }

        protected void setReader(Reader reader) throws IOException {
            this.source.setReader(reader);
        }

        public TokenStream getTokenStream() {
            return this.sink;
        }

        public Tokenizer getTokenizer() {
            return this.source;
        }
    }
}

