/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.internal.nls;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static ResourceBundle bundle = null;

    public static String getString(String msg) {
        if (bundle == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException e) {
            return "Missing message: " + msg;
        }
    }

    public static String getString(String msg, Object arg) {
        return Messages.getString(msg, new Object[]{arg});
    }

    public static String getString(String msg, int arg) {
        return Messages.getString(msg, new Object[]{Integer.toString(arg)});
    }

    public static String getString(String msg, char arg) {
        return Messages.getString(msg, new Object[]{String.valueOf(arg)});
    }

    public static String getString(String msg, Object arg1, Object arg2) {
        return Messages.getString(msg, new Object[]{arg1, arg2});
    }

    public static String getString(String msg, Object[] args) {
        String format2 = msg;
        if (bundle != null) {
            try {
                format2 = bundle.getString(msg);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return Messages.format(format2, args);
    }

    public static String format(String format2, Object[] args) {
        StringBuilder answer = new StringBuilder(format2.length() + args.length * 20);
        String[] argStrings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argStrings[i] = args[i] == null ? "<null>" : args[i].toString();
        }
        int lastI = 0;
        int i = format2.indexOf(123, 0);
        while (i >= 0) {
            if (i != 0 && format2.charAt(i - 1) == '\\') {
                if (i != 1) {
                    answer.append(format2.substring(lastI, i - 1));
                }
                answer.append('{');
                lastI = i + 1;
            } else if (i > format2.length() - 3) {
                answer.append(format2.substring(lastI, format2.length()));
                lastI = format2.length();
            } else {
                byte argnum = (byte)Character.digit(format2.charAt(i + 1), 10);
                if (argnum < 0 || format2.charAt(i + 2) != '}') {
                    answer.append(format2.substring(lastI, i + 1));
                    lastI = i + 1;
                } else {
                    answer.append(format2.substring(lastI, i));
                    if (argnum >= argStrings.length) {
                        answer.append("<missing argument>");
                    } else {
                        answer.append(argStrings[argnum]);
                    }
                    lastI = i + 3;
                }
            }
            i = format2.indexOf(123, lastI);
        }
        if (lastI < format2.length()) {
            answer.append(format2.substring(lastI, format2.length()));
        }
        return answer.toString();
    }
}

