/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerCompressor;
import net.minidev.json.parser.FakeContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    private static final FakeContainerFactory FACTORY_FAKE_COINTAINER = new FakeContainerFactory();

    public static Object parse(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void SAXParse(InputStream input2, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input2, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(Reader input2, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input2, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(String input2, ContentHandler handler) throws ParseException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input2, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static String compress(String input2, JSONStyle style) {
        try {
            StringBuilder sb = new StringBuilder();
            ContentHandlerCompressor comp = new ContentHandlerCompressor(sb, style);
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            p.parse(input2, (ContainerFactory)FACTORY_FAKE_COINTAINER, (ContentHandler)comp);
            return sb.toString();
        }
        catch (Exception e) {
            return input2;
        }
    }

    public static String compress(String s) {
        return JSONValue.compress(s, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String s) {
        return JSONValue.compress(s, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(byte[] in, int offset, int length) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(InputStream in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(String s) throws ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(InputStream in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(Reader in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(String s) throws ParseException {
        return new JSONParser(400).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s) throws ParseException {
        return new JSONParser(400).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s, int offset, int length) throws ParseException {
        return new JSONParser(400).parse(s, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static boolean isValidJsonStrict(Reader in) throws IOException {
        try {
            new JSONParser(400).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String s) {
        try {
            new JSONParser(400).parse(s, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(Reader in) throws IOException {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(String s) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void writeJSONString(Object value2, Appendable out) throws IOException {
        JSONValue.writeJSONString(value2, out, COMPRESSION);
    }

    public static void writeJSONString(Object value2, Appendable out, JSONStyle compression) throws IOException {
        if (value2 == null) {
            out.append("null");
            return;
        }
        if (value2 instanceof String) {
            if (!compression.mustProtectValue((String)value2)) {
                out.append((String)value2);
            } else {
                out.append('\"');
                JSONValue.escape((String)value2, out, compression);
                out.append('\"');
            }
            return;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof Double) {
                if (((Double)value2).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value2.toString());
                }
            } else if (value2 instanceof Float) {
                if (((Float)value2).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value2.toString());
                }
            } else {
                out.append(value2.toString());
            }
            return;
        }
        if (value2 instanceof Boolean) {
            out.append(value2.toString());
        } else if (value2 instanceof JSONStreamAware) {
            if (value2 instanceof JSONStreamAwareEx) {
                ((JSONStreamAwareEx)value2).writeJSONString(out, compression);
            } else {
                ((JSONStreamAware)value2).writeJSONString(out);
            }
        } else if (value2 instanceof JSONAware) {
            if (value2 instanceof JSONAwareEx) {
                out.append(((JSONAwareEx)value2).toJSONString(compression));
            } else {
                out.append(((JSONAware)value2).toJSONString());
            }
        } else if (value2 instanceof Map) {
            JSONObject.writeJSON((Map)value2, out, compression);
        } else if (value2 instanceof Iterable) {
            JSONArray.writeJSONString((Iterable)value2, out, compression);
        } else if (value2 instanceof Date) {
            JSONValue.writeJSONString(value2.toString(), out, compression);
        } else {
            if (value2 instanceof Enum) {
                String s = ((Enum)value2).name();
                if (!compression.mustProtectValue(s)) {
                    out.append(s);
                } else {
                    out.append('\"');
                    JSONValue.escape(s, out, compression);
                    out.append('\"');
                }
                return;
            }
            if (value2.getClass().isArray()) {
                Class<?> arrayClz = value2.getClass();
                Class<?> c = arrayClz.getComponentType();
                out.append('[');
                boolean needSep = false;
                if (c.isPrimitive()) {
                    if (c == Integer.TYPE) {
                        for (int b : (int[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Integer.toString(b));
                        }
                    } else if (c == Short.TYPE) {
                        for (short b : (short[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Short.toString(b));
                        }
                    } else if (c == Byte.TYPE) {
                        for (byte b : (byte[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Byte.toString(b));
                        }
                    } else if (c == Long.TYPE) {
                        for (long b : (long[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Long.toString(b));
                        }
                    } else if (c == Float.TYPE) {
                        for (float b : (float[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Float.toString(b));
                        }
                    } else if (c == Double.TYPE) {
                        for (double b : (double[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            out.append(Double.toString(b));
                        }
                    } else if (c == Boolean.TYPE) {
                        for (boolean b : (boolean[])value2) {
                            if (needSep) {
                                out.append(',');
                            } else {
                                needSep = true;
                            }
                            if (b) {
                                out.append("true");
                                continue;
                            }
                            out.append("false");
                        }
                    }
                } else {
                    for (Object o : (Object[])value2) {
                        if (needSep) {
                            out.append(',');
                        } else {
                            needSep = true;
                        }
                        JSONValue.writeJSONString(o, out, compression);
                    }
                }
                out.append(']');
            } else {
                try {
                    Class<?> cls = value2.getClass();
                    boolean needSep = false;
                    Field[] fields = cls.getDeclaredFields();
                    out.append('{');
                    for (Field field2 : fields) {
                        int m = field2.getModifiers();
                        if ((m & 0x98) > 0) continue;
                        Object v = null;
                        if ((m & 1) > 0) {
                            v = field2.get(value2);
                        } else {
                            Class<?> c2;
                            String g = JSONUtil.getGetterName(field2.getName());
                            Method mtd = null;
                            try {
                                mtd = cls.getDeclaredMethod(g, new Class[0]);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (mtd == null && ((c2 = field2.getType()) == Boolean.TYPE || c2 == Boolean.class)) {
                                g = JSONUtil.getIsName(field2.getName());
                                mtd = cls.getDeclaredMethod(g, new Class[0]);
                            }
                            if (mtd == null) continue;
                            v = mtd.invoke(value2, new Object[0]);
                        }
                        if (needSep) {
                            out.append(',');
                        } else {
                            needSep = true;
                        }
                        JSONObject.writeJSONKV(field2.getName(), v, out, compression);
                    }
                    out.append('}');
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String toJSONString(Object value2) {
        return JSONValue.toJSONString(value2, COMPRESSION);
    }

    public static String toJSONString(Object value2, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value2, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s) {
        return JSONValue.escape(s, COMPRESSION);
    }

    public static String escape(String s, JSONStyle compression) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        compression.escape(s, sb);
        return sb.toString();
    }

    public static void escape(String s, Appendable ap) {
        JSONValue.escape(s, ap, COMPRESSION);
    }

    public static void escape(String s, Appendable ap, JSONStyle compression) {
        if (s == null) {
            return;
        }
        compression.escape(s, ap);
    }
}

