/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends HashMap<String, Object>
implements JSONAware,
JSONAwareEx,
JSONStreamAwareEx {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public static String escape(String s) {
        return JSONValue.escape(s);
    }

    public static String toJSONString(Map<String, ? extends Object> map2) {
        return JSONObject.toJSONString(map2, JSONValue.COMPRESSION);
    }

    public static String toJSONString(Map<String, ? extends Object> map2, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject.writeJSON(map2, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void writeJSONKV(String key, Object value2, Appendable out, JSONStyle compression) throws IOException {
        if (key == null) {
            out.append("null");
        } else if (!compression.mustProtectKey(key)) {
            out.append(key);
        } else {
            out.append('\"');
            JSONValue.escape(key, out, compression);
            out.append('\"');
        }
        compression.objectEndOfKey(out);
        if (value2 instanceof String) {
            if (!compression.mustProtectValue((String)value2)) {
                out.append((String)value2);
            } else {
                out.append('\"');
                JSONValue.escape((String)value2, out, compression);
                out.append('\"');
            }
        } else {
            JSONValue.writeJSONString(value2, out, compression);
        }
    }

    public JSONObject(Map<String, ?> map2) {
        super(map2);
    }

    public static void writeJSON(Map<String, Object> map2, Appendable out) throws IOException {
        JSONObject.writeJSON(map2, out, JSONValue.COMPRESSION);
    }

    public static void writeJSON(Map<String, ? extends Object> map2, Appendable out, JSONStyle compression) throws IOException {
        if (map2 == null) {
            out.append("null");
            return;
        }
        boolean first = true;
        compression.objectStart(out);
        for (Map.Entry<String, ? extends Object> entry2 : map2.entrySet()) {
            if (first) {
                compression.objectFirstStart(out);
                first = false;
            } else {
                compression.objectNext(out);
            }
            JSONObject.writeJSONKV(entry2.getKey().toString(), entry2.getValue(), out, compression);
            compression.objectElmStop(out);
        }
        compression.objectStop(out);
    }

    @Override
    public void writeJSONString(Appendable out) throws IOException {
        JSONObject.writeJSON(this, out, JSONValue.COMPRESSION);
    }

    @Override
    public void writeJSONString(Appendable out, JSONStyle compression) throws IOException {
        JSONObject.writeJSON(this, out, compression);
    }

    public void merge(Object o2) {
        JSONObject.merge(this, o2);
    }

    protected static JSONObject merge(JSONObject o1, Object o2) {
        if (o2 == null) {
            return o1;
        }
        if (o2 instanceof JSONObject) {
            return JSONObject.merge(o1, (JSONObject)o2);
        }
        throw new RuntimeException("JSON megre can not merge JSONObject with " + o2.getClass());
    }

    private static JSONObject merge(JSONObject o1, JSONObject o2) {
        if (o2 == null) {
            return o1;
        }
        for (String key : o1.keySet()) {
            Object value1 = o1.get(key);
            Object value2 = o2.get(key);
            if (value2 == null) continue;
            if (value1 instanceof JSONArray) {
                o1.put(key, JSONObject.merge((JSONArray)value1, value2));
                continue;
            }
            if (value1 instanceof JSONObject) {
                o1.put(key, JSONObject.merge((JSONObject)value1, value2));
                continue;
            }
            if (value1.equals(value2)) continue;
            if (value1.getClass().equals(value2.getClass())) {
                throw new RuntimeException("JSON merge can not merge two " + value1.getClass().getName() + " Object together");
            }
            throw new RuntimeException("JSON merge can not merge " + value1.getClass().getName() + " with " + value2.getClass().getName());
        }
        for (String key : o2.keySet()) {
            if (o1.containsKey(key)) continue;
            o1.put(key, o2.get(key));
        }
        return o1;
    }

    protected static JSONArray merge(JSONArray o1, Object o2) {
        if (o2 == null) {
            return o1;
        }
        if (o1 instanceof JSONArray) {
            return JSONObject.merge(o1, (JSONArray)o2);
        }
        o1.add(o2);
        return o1;
    }

    private static JSONArray merge(JSONArray o1, JSONArray o2) {
        o1.addAll(o2);
        return o1;
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }

    @Override
    public String toJSONString(JSONStyle compression) {
        return JSONObject.toJSONString(this, compression);
    }

    public String toString(JSONStyle compression) {
        return JSONObject.toJSONString(this, compression);
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }
}

